/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;
import ucar.unidata.geoloc.vertical.VTfromExistingData;
import ucar.unidata.geoloc.vertical.VerticalTransform;
import ucar.unidata.util.Parameter;

public class VExplicitField
extends AbstractCoordTransBuilder {
    public String getTransformName() {
        return "explicit_field";
    }

    public TransformType getTransformType() {
        return TransformType.Vertical;
    }

    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        VerticalCT ct = new VerticalCT(ctv.getShortName(), this.getTransformName(), VerticalCT.Type.Existing3DField, this);
        String fieldName = ds.findAttValueIgnoreCase(ctv, "existingDataField", null);
        if (null == fieldName) {
            throw new IllegalArgumentException("ExplicitField Vertical Transform must have attribute existingDataField");
        }
        ct.addParameter(new Parameter("standard_name", this.getTransformName()));
        ct.addParameter(new Parameter("existingDataField", fieldName));
        return ct;
    }

    public VerticalTransform makeMathTransform(NetcdfDataset ds, Dimension timeDim, VerticalCT vCT) {
        return new VTfromExistingData(ds, timeDim, vCT.getParameters());
    }
}

