/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.instruct.TerminationException;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.trace.AbstractTraceListener;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trace.TimingCodeInjector;
import net.sf.saxon.trace.TimingTraceListener;
import net.sf.saxon.trace.XSLTTraceListener;
import net.sf.saxon.trans.CommandLineOptions;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.LicenseException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DateTimeValue;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class Transform {
    protected Configuration config;
    protected CompilerInfo compilerInfo;
    protected boolean useURLs = false;
    protected boolean showTime = false;
    protected int repeat = 1;
    String sourceParserName = null;
    boolean schemaAware = false;

    public static void main(String[] args) throws Exception {
        new Transform().doTransform(args, "java net.sf.saxon.Transform");
    }

    public void setPermittedOptions(CommandLineOptions options) {
        options.addRecognizedOption("a", 1, "Use <?xml-stylesheet?> processing instruction to identify stylesheet");
        options.addRecognizedOption("catalog", 258, "Use specified catalog file to resolve URIs");
        options.addRecognizedOption("config", 258, "Use specified configuration file");
        options.addRecognizedOption("cr", 259, "Use specified collection URI resolver class");
        options.addRecognizedOption("dtd", 4, "Validate using DTD");
        options.setPermittedValues("dtd", new String[]{"on", "off", "recover"}, "on");
        options.addRecognizedOption("expand", 1, "Expand attribute defaults from DTD or Schema");
        options.addRecognizedOption("explain", 2, "Display compiled expression tree and optimization decisions");
        options.addRecognizedOption("ext", 1, "Allow calls to Java extension functions and xsl:result-document");
        options.addRecognizedOption("im", 262, "Name of initial mode");
        options.addRecognizedOption("init", 3, "User-supplied net.sf.saxon.lib.Initializer class to initialize the Saxon Configuration");
        options.addRecognizedOption("it", 262, "Name of initial template");
        options.addRecognizedOption("l", 1, "Maintain line numbers for source documents");
        options.addRecognizedOption("m", 3, "Use named class to handle xsl:message output");
        options.addRecognizedOption("now", 264, "Run with specified current date/time");
        options.addRecognizedOption("o", 258, "Use specified file for primary output");
        options.addRecognizedOption("opt", 261, "Use optimization level 0..10");
        options.addRecognizedOption("or", 259, "Use named OutputURIResolver class");
        options.addRecognizedOption("outval", 260, "Action when validation of output file fails");
        options.setPermittedValues("outval", new String[]{"recover", "fatal"}, null);
        options.addRecognizedOption("p", 1, "Recognize query parameters in URI passed to doc()");
        options.addRecognizedOption("r", 259, "Use named URIResolver class");
        options.addRecognizedOption("repeat", 261, "Run N times for performance measurement");
        options.addRecognizedOption("s", 258, "Source file for primary input");
        options.addRecognizedOption("sa", 1, "Run in schema-aware mode");
        options.addRecognizedOption("strip", 260, "Handling of whitespace text nodes in source documents");
        options.setPermittedValues("strip", new String[]{"none", "all", "ignorable"}, null);
        options.addRecognizedOption("t", 1, "Display version and timing information, and names of output files");
        options.addRecognizedOption("T", 3, "Use named TraceListener class, or standard TraceListener");
        options.addRecognizedOption("TJ", 1, "Debug binding and execution of extension functions");
        options.setPermittedValues("TJ", new String[]{"on", "off"}, "on");
        options.addRecognizedOption("TP", 2, "Use profiling trace listener, with specified output file");
        options.addRecognizedOption("threads", 261, "Run stylesheet on directory of files divided in N threads");
        options.addRecognizedOption("tree", 260, "Use specified tree model for source documents");
        options.setPermittedValues("tree", new String[]{"linked", "tiny", "tinyc"}, null);
        options.addRecognizedOption("traceout", 258, "File for output of trace() and -T output");
        options.addRecognizedOption("u", 1, "Interpret filename arguments as URIs");
        options.setPermittedValues("u", new String[]{"on", "off"}, "on");
        options.addRecognizedOption("val", 260, "Apply validation to source documents");
        options.setPermittedValues("val", new String[]{"strict", "lax"}, "strict");
        options.addRecognizedOption("versionmsg", 1, "Output warning when stylesheet specifies version='1.0");
        options.addRecognizedOption("warnings", 260, "Handling of recoverable dynamic errors");
        options.setPermittedValues("warnings", new String[]{"silent", "recover", "fatal"}, null);
        options.addRecognizedOption("x", 259, "Use named XMLReader class for parsing source documents");
        options.addRecognizedOption("xi", 1, "Expand XInclude directives in source documents");
        options.addRecognizedOption("xmlversion", 260, "Indicate whether XML 1.1 is supported");
        options.setPermittedValues("xmlversion", new String[]{"1.0", "1.1"}, null);
        options.addRecognizedOption("xsd", 263, "List of schema documents to be preloaded");
        options.addRecognizedOption("xsdversion", 260, "Indicate whether XSD 1.1 is supported");
        options.setPermittedValues("xsdversion", new String[]{"1.0", "1.1"}, null);
        options.addRecognizedOption("xsiloc", 1, "Load schemas named in xsi:schemaLocation (default on)");
        options.addRecognizedOption("xsl", 258, "Stylesheet file");
        options.addRecognizedOption("xsltversion", 260, "Indicate whether the XSLT processor should support XSLT 2.0 or XSLT 3.0");
        options.setPermittedValues("xsltversion", new String[]{"0.0", "2.0", "2.1", "3.0"}, null);
        options.addRecognizedOption("y", 259, "Use named XMLReader class for parsing stylesheet and schema documents");
        options.addRecognizedOption("?", 512, "Display command line help text");
    }

    public void doTransform(String[] args, String command) {
        String sourceFileName = null;
        String styleFileName = null;
        File outputFile = null;
        String outputFileName = null;
        boolean wholeDirectory = false;
        boolean dtdValidation = false;
        String styleParserName = null;
        boolean explain = false;
        String explainOutputFileName = null;
        String additionalSchemas = null;
        TraceListener traceListener = null;
        boolean closeTraceDestination = false;
        TransformThread[] th = null;
        int threadCount = 0;
        CommandLineOptions options = new CommandLineOptions();
        this.setPermittedOptions(options);
        try {
            options.setActualOptions(args);
        }
        catch (XPathException err) {
            Transform.quit(err.getMessage(), 2);
        }
        this.schemaAware = false;
        String configFile = options.getOptionValue("config");
        if (configFile != null) {
            try {
                this.config = Configuration.readConfiguration(new StreamSource(configFile));
                this.initializeConfiguration(this.config);
                this.schemaAware = this.config.isLicensedFeature(2);
                this.compilerInfo = this.config.getDefaultXsltCompilerInfo();
            }
            catch (XPathException e) {
                Transform.quit(e.getMessage(), 2);
            }
        }
        if (this.config == null && !this.schemaAware) {
            this.schemaAware = options.testIfSchemaAware();
        }
        if (this.config == null) {
            this.config = Configuration.newConfiguration();
            this.initializeConfiguration(this.config);
            this.config.setVersionWarning(true);
            try {
                this.setFactoryConfiguration(this.schemaAware, null);
                this.compilerInfo = this.config.getDefaultXsltCompilerInfo();
                if (this.schemaAware) {
                    this.config.checkLicensedFeature(2, "schema-aware XSLT");
                    this.compilerInfo.setSchemaAware(true);
                } else {
                    this.compilerInfo.setSchemaAware(false);
                }
            }
            catch (Exception err) {
                err.printStackTrace();
                Transform.quit(err.getMessage(), 2);
            }
        }
        try {
            PrintStream traceDestination;
            options.applyToConfiguration(this.config);
            boolean useAssociatedStylesheet = "on".equals(options.getOptionValue("a"));
            String value = options.getOptionValue("explain");
            if (value != null) {
                explain = true;
                this.config.setConfigurationProperty("http://saxon.sf.net/feature/trace-optimizer-decisions", Boolean.TRUE);
                if (!"".equals(value)) {
                    explainOutputFileName = value;
                }
            }
            if ((value = options.getOptionValue("o")) != null) {
                outputFileName = value;
            }
            if ("on".equals(value = options.getOptionValue("p"))) {
                this.config.setParameterizedURIResolver();
                this.useURLs = true;
            }
            if ((value = options.getOptionValue("repeat")) != null) {
                try {
                    this.repeat = Integer.parseInt(value);
                }
                catch (NumberFormatException err) {
                    this.badUsage("Bad number after -repeat");
                }
            }
            if ((value = options.getOptionValue("s")) != null) {
                sourceFileName = value;
            }
            if ((value = options.getOptionValue("threads")) != null) {
                threadCount = Integer.parseInt(value);
            }
            if ((value = options.getOptionValue("t")) != null) {
                System.err.println(this.config.getProductTitle());
                System.err.println(Configuration.getPlatform().getPlatformVersion());
                this.config.setConfigurationProperty("http://saxon.sf.net/feature/timing", true);
                this.showTime = true;
            }
            if ((value = options.getOptionValue("T")) != null) {
                traceListener = "".equals(value) ? new XSLTTraceListener() : this.config.makeTraceListener(value);
                this.config.setConfigurationProperty("http://saxon.sf.net/feature/traceListener", traceListener);
                this.config.setConfigurationProperty("http://saxon.sf.net/feature/linenumbering", Boolean.TRUE);
            }
            if ((value = options.getOptionValue("TP")) != null) {
                traceListener = new TimingTraceListener();
                this.config.setConfigurationProperty("http://saxon.sf.net/feature/traceListener", traceListener);
                this.config.setConfigurationProperty("http://saxon.sf.net/feature/linenumbering", Boolean.TRUE);
                this.config.getDefaultXsltCompilerInfo().setCodeInjector(new TimingCodeInjector());
                if (value.length() > 0) {
                    traceListener.setOutputDestination(new PrintStream(new FileOutputStream(new File(value))));
                }
            }
            if ((value = options.getOptionValue("traceout")) == null) {
                traceDestination = this.config.getStandardErrorOutput();
            } else if (value.equals("#err")) {
                traceDestination = System.err;
            } else if (value.equals("#out")) {
                traceDestination = System.out;
            } else if (value.equals("#null")) {
                traceDestination = null;
            } else {
                traceDestination = new PrintStream(new FileOutputStream(new File(value)));
                closeTraceDestination = true;
            }
            value = options.getOptionValue("u");
            if (value != null) {
                this.useURLs = "on".equals(value);
            }
            if ((value = options.getOptionValue("x")) != null) {
                this.sourceParserName = value;
                this.config.setConfigurationProperty("http://saxon.sf.net/feature/sourceParserClass", this.sourceParserName);
            }
            if ((value = options.getOptionValue("xsd")) != null) {
                additionalSchemas = value;
            }
            if ((value = options.getOptionValue("xsdversion")) != null) {
                this.config.setConfigurationProperty("http://saxon.sf.net/feature/xsd-version", value);
            }
            if ((value = options.getOptionValue("xsl")) != null) {
                styleFileName = value;
            }
            if ((value = options.getOptionValue("y")) != null) {
                styleParserName = value;
                this.config.setConfigurationProperty("http://saxon.sf.net/feature/sourceParserClass", value);
            }
            if ((value = options.getOptionValue("?")) != null) {
                this.badUsage("");
            }
            this.compilerInfo.setRecoveryPolicy(this.config.getRecoveryPolicy());
            this.applyLocalOptions(options, this.config);
            if (options.getOptionValue("it") != null && useAssociatedStylesheet) {
                this.badUsage("-it and -a options cannot be used together");
            }
            List<String> positional = options.getPositionalOptions();
            int currentPositionalOption = 0;
            if (options.getOptionValue("it") == null && sourceFileName == null) {
                if (positional.size() == currentPositionalOption) {
                    this.badUsage("No source file name");
                }
                sourceFileName = positional.get(currentPositionalOption++);
            }
            if (!useAssociatedStylesheet && styleFileName == null) {
                if (positional.size() == currentPositionalOption) {
                    this.badUsage("No stylesheet file name");
                }
                styleFileName = positional.get(currentPositionalOption++);
            }
            if (currentPositionalOption < positional.size()) {
                this.badUsage("Unrecognized option: " + positional.get(currentPositionalOption));
            }
            this.config.displayLicenseMessage();
            if (this.schemaAware) {
                this.config.checkLicensedFeature(2, "schema-aware XSLT");
            }
            if (traceListener instanceof AbstractTraceListener && traceDestination != null) {
                traceListener.setOutputDestination(traceDestination);
            }
            if (additionalSchemas != null) {
                CommandLineOptions.loadAdditionalSchemas(this.config, additionalSchemas);
            }
            List sources = null;
            if (sourceFileName != null) {
                boolean useSAXSource = this.sourceParserName != null || dtdValidation;
                Object loaded = CommandLineOptions.loadDocuments(sourceFileName, this.useURLs, this.config, useSAXSource);
                if (loaded instanceof List) {
                    wholeDirectory = true;
                    sources = (List)loaded;
                } else {
                    wholeDirectory = false;
                    sources = new ArrayList<Object>(1);
                    sources.add(loaded);
                }
                sources = this.preprocess(sources);
                if (wholeDirectory) {
                    if (outputFileName == null) {
                        Transform.quit("To process a directory, -o must be specified", 2);
                    } else if (outputFileName.equals(sourceFileName)) {
                        Transform.quit("Output directory must be different from input", 2);
                    } else {
                        outputFile = new File(outputFileName);
                        if (!outputFile.isDirectory()) {
                            Transform.quit("Input is a directory, but output is not", 2);
                        }
                    }
                }
            }
            if (outputFileName != null && !wholeDirectory && (outputFile = new File(outputFileName)).isDirectory()) {
                Transform.quit("Output is a directory, but input is not", 2);
            }
            if (useAssociatedStylesheet) {
                if (wholeDirectory) {
                    this.processDirectoryAssoc(sources, outputFile, options, traceDestination);
                } else {
                    this.processFileAssoc((Source)sources.get(0), null, outputFile, options, traceDestination);
                }
            } else {
                Source styleSource;
                long startTime = new Date().getTime();
                PreparedStylesheet sheet = null;
                XMLReader styleParser = null;
                if (this.useURLs || styleFileName.startsWith("http:") || styleFileName.startsWith("file:")) {
                    styleSource = this.config.getURIResolver().resolve(styleFileName, null);
                    if (styleSource == null) {
                        styleSource = this.config.getSystemURIResolver().resolve(styleFileName, null);
                    }
                } else if (styleFileName.equals("-")) {
                    if (styleParserName == null) {
                        styleSource = new StreamSource(System.in);
                    } else if (Configuration.getPlatform().isJava()) {
                        styleParser = this.config.getStyleParser();
                        styleSource = new SAXSource(styleParser, new InputSource(System.in));
                    } else {
                        styleSource = new StreamSource(System.in);
                    }
                } else {
                    File sheetFile = new File(styleFileName);
                    if (!sheetFile.exists()) {
                        Transform.quit("Stylesheet file " + sheetFile + " does not exist", 2);
                    }
                    if (styleParserName == null) {
                        styleSource = new StreamSource(sheetFile.toURI().toString());
                    } else {
                        InputSource eis = new InputSource(sheetFile.toURI().toString());
                        styleParser = this.config.getStyleParser();
                        styleSource = new SAXSource(styleParser, eis);
                    }
                }
                if (styleSource == null) {
                    Transform.quit("URIResolver for stylesheet file must return a Source", 2);
                }
                for (int j = 0; j < this.repeat; ++j) {
                    sheet = PreparedStylesheet.compile(styleSource, this.config, this.compilerInfo);
                    if (styleParser != null) {
                        this.config.reuseStyleParser(styleParser);
                    }
                    if (!this.showTime) continue;
                    long endTime = Transform.now();
                    System.err.println("Stylesheet compilation time: " + (endTime - startTime) + " milliseconds");
                    startTime = endTime;
                }
                if (explain) {
                    OutputStream explainOutput = explainOutputFileName == null ? this.config.getStandardErrorOutput() : new FileOutputStream(new File(explainOutputFileName));
                    Properties props = ExpressionPresenter.makeDefaultProperties();
                    Receiver diag = this.config.getSerializerFactory().getReceiver(new StreamResult(explainOutput), this.config.makePipelineConfiguration(), props);
                    ExpressionPresenter expressionPresenter = new ExpressionPresenter(this.config, diag);
                    sheet.explain(expressionPresenter);
                    expressionPresenter.close();
                }
                if (wholeDirectory) {
                    if (threadCount > 0 && sources.size() > 1) {
                        int i;
                        if (threadCount > sources.size()) {
                            threadCount = sources.size();
                        }
                        int sourcesPerThread = (int)Math.floor(sources.size() / threadCount);
                        int rem = sources.size() % threadCount;
                        th = new TransformThread[threadCount];
                        int j = 0;
                        int z = 0;
                        for (i = 0; i < sources.size(); i += sourcesPerThread + z) {
                            z = j < rem ? 1 : 0;
                            th[j] = new TransformThread(i, sheet, sources.subList(i, i + sourcesPerThread + z), outputFile, options, traceDestination);
                            th[j].start();
                            ++j;
                        }
                        for (i = 0; i < th.length; ++i) {
                            th[i].join();
                        }
                    } else {
                        this.processDirectory(sources, sheet, outputFile, options, traceDestination);
                    }
                } else {
                    Source source = sources == null ? null : (Source)sources.get(0);
                    this.processFile(source, sheet, outputFile, options, traceDestination);
                }
                if (closeTraceDestination) {
                    traceDestination.close();
                }
            }
        }
        catch (TerminationException err) {
            Transform.quit(err.getMessage(), 1);
        }
        catch (TransformerConfigurationException err) {
            Transform.quit(err.getMessage(), 2);
        }
        catch (TransformerException err) {
            Transform.quit("Transformation failed: " + err.getMessage(), 2);
        }
        catch (TransformerFactoryConfigurationError err) {
            Transform.quit("Transformation failed: " + err.getMessage(), 2);
        }
        catch (LicenseException err) {
            Transform.quit("Transformation failed: " + err.getMessage(), 2);
        }
        catch (Exception err2) {
            err2.printStackTrace();
            Transform.quit("Fatal error during transformation: " + err2.getClass().getName() + ": " + (err2.getMessage() == null ? " (no message)" : err2.getMessage()), 2);
        }
    }

    protected void initializeConfiguration(Configuration config) {
    }

    public void setFactoryConfiguration(boolean schemaAware, String className) throws LicenseException {
    }

    protected void applyLocalOptions(CommandLineOptions options, Configuration config) {
    }

    public List preprocess(List sources) throws XPathException {
        return sources;
    }

    protected Configuration getConfiguration() {
        return this.config;
    }

    protected static void quit(String message, int code) {
        System.err.println(message);
        System.exit(code);
    }

    private void processDirectoryAssoc(List sources, File outputDir, CommandLineOptions options, PrintStream traceDestination) throws Exception {
        int failures = 0;
        for (int f = 0; f < sources.size(); ++f) {
            Source source = (Source)sources.get(f);
            String localName = Transform.getLocalFileName(source);
            try {
                this.processFileAssoc(source, localName, outputDir, options, traceDestination);
                continue;
            }
            catch (XPathException err) {
                ++failures;
                System.err.println("While processing " + localName + ": " + err.getMessage() + '\n');
            }
        }
        if (failures > 0) {
            throw new XPathException(failures + " transformation" + (failures == 1 ? "" : "s") + " failed");
        }
    }

    private File makeOutputFile(File directory, String localName, Templates sheet) {
        String mediaType = sheet.getOutputProperties().getProperty("media-type");
        String suffix = ".xml";
        if ("text/html".equals(mediaType)) {
            suffix = ".html";
        } else if ("text/plain".equals(mediaType)) {
            suffix = ".txt";
        }
        String prefix = localName;
        if (localName.endsWith(".xml") || localName.endsWith(".XML")) {
            prefix = localName.substring(0, localName.length() - 4);
        }
        return new File(directory, prefix + suffix);
    }

    private void processFileAssoc(Source sourceInput, String localName, File outputFile, CommandLineOptions options, PrintStream traceDestination) throws TransformerException {
        if (this.showTime) {
            System.err.println("Processing " + sourceInput.getSystemId() + " using associated stylesheet");
        }
        long startTime = Transform.now();
        Source style = PreparedStylesheet.getAssociatedStylesheet(this.config, sourceInput, null, null, null);
        PreparedStylesheet sheet = PreparedStylesheet.compile(style, this.config, this.compilerInfo);
        if (this.showTime) {
            System.err.println("Prepared associated stylesheet " + style.getSystemId());
        }
        Controller controller = this.newController(sheet, options, traceDestination);
        File outFile = outputFile;
        if (outFile != null && outFile.isDirectory()) {
            outFile = this.makeOutputFile(outFile, localName, sheet);
        }
        StreamResult result = outFile == null ? new StreamResult(System.out) : new StreamResult(outFile.toURI().toString());
        try {
            controller.transform(sourceInput, result);
        }
        catch (TerminationException err) {
            throw err;
        }
        catch (XPathException err) {
            if (!err.hasBeenReported()) {
                err.printStackTrace();
            }
            throw new XPathException("Run-time errors were reported");
        }
        if (this.showTime) {
            long endTime = Transform.now();
            System.err.println("Execution time: " + CommandLineOptions.showExecutionTime(endTime - startTime));
        }
    }

    protected Controller newController(Templates sheet, CommandLineOptions options, PrintStream traceDestination) throws TransformerException {
        String now;
        String initialTemplate;
        Controller controller = (Controller)sheet.newTransformer();
        options.setParams(this.config, controller, null, null);
        controller.setTraceFunctionDestination(traceDestination);
        String initialMode = options.getOptionValue("im");
        if (initialMode != null) {
            controller.setInitialMode(initialMode);
        }
        if ((initialTemplate = options.getOptionValue("it")) != null) {
            controller.setInitialTemplate(initialTemplate);
        }
        if ((now = options.getOptionValue("now")) != null) {
            DateTimeValue currentDateTime = (DateTimeValue)DateTimeValue.makeDateTimeValue(now, this.config.getConversionRules()).asAtomic();
            controller.setCurrentDateTime(currentDateTime);
        }
        return controller;
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    private void processDirectory(List sources, Templates sheet, File outputDir, CommandLineOptions options, PrintStream traceDestination) throws TransformerException {
        int failures = 0;
        for (int f = 0; f < sources.size(); ++f) {
            Source source = (Source)sources.get(f);
            String localName = Transform.getLocalFileName(source);
            try {
                File outputFile = this.makeOutputFile(outputDir, localName, sheet);
                this.processFile(source, sheet, outputFile, options, traceDestination);
                continue;
            }
            catch (XPathException err) {
                ++failures;
                System.err.println("While processing " + localName + ": " + err.getMessage() + '\n');
            }
        }
        if (failures > 0) {
            throw new XPathException(failures + " transformation" + (failures == 1 ? "" : "s") + " failed");
        }
    }

    private static String getLocalFileName(Source source) {
        try {
            String path = new URI(source.getSystemId()).getPath();
            while (true) {
                int sep;
                if ((sep = path.indexOf(47)) < 0) {
                    return path;
                }
                path = path.substring(sep + 1);
            }
        }
        catch (URISyntaxException err) {
            throw new IllegalArgumentException(err.getMessage());
        }
    }

    private void processFile(Source source, Templates sheet, File outputFile, CommandLineOptions options, PrintStream traceDestination) throws TransformerException {
        long totalTime = 0L;
        int runs = 0;
        for (int r = 0; r < this.repeat; ++r) {
            if (this.showTime) {
                String initialTemplate;
                String msg = "Processing ";
                msg = source != null ? msg + source.getSystemId() : msg + " (no source document)";
                String initialMode = options.getOptionValue("im");
                if (initialMode != null) {
                    msg = msg + " initial mode = " + initialMode;
                }
                if ((initialTemplate = options.getOptionValue("it")) != null) {
                    msg = msg + " initial template = " + initialTemplate;
                }
                System.err.println(msg);
            }
            long startTime = Transform.now();
            ++runs;
            Controller controller = this.newController(sheet, options, traceDestination);
            StreamResult result = outputFile == null ? new StreamResult(System.out) : new StreamResult(outputFile.toURI().toString());
            try {
                controller.transform(source, result);
            }
            catch (TerminationException err) {
                throw err;
            }
            catch (XPathException err) {
                if (!err.hasBeenReported()) {
                    err.printStackTrace();
                }
                throw new XPathException("Run-time errors were reported");
            }
            long endTime = Transform.now();
            totalTime += endTime - startTime;
            if (this.showTime) {
                System.err.println("Execution time: " + CommandLineOptions.showExecutionTime(endTime - startTime));
                System.err.println("Memory used: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
                this.config.getNamePool().statistics();
                if (this.repeat > 1) {
                    System.err.println("-------------------------------");
                    Runtime.getRuntime().gc();
                }
            }
            if (this.repeat == 999999 && totalTime > 60000L) break;
        }
        if (this.repeat > 1) {
            System.err.println("*** Average execution time over " + runs + " runs: " + totalTime / (long)runs + "ms");
        }
    }

    protected void badUsage(String message) {
        if (!"".equals(message)) {
            System.err.println(message);
        }
        if (!this.showTime) {
            System.err.println(this.config.getProductTitle());
        }
        System.err.println("Usage: see http://www.saxonica.com/documentation/using-xsl/commandline.xml");
        System.err.println("Format: " + this.getClass().getName() + " options params");
        CommandLineOptions options = new CommandLineOptions();
        this.setPermittedOptions(options);
        System.err.println("Options available:" + options.displayPermittedOptions());
        System.err.println("Use -XYZ:? for details of option XYZ");
        System.err.println("Params: ");
        System.err.println("  param=value           Set stylesheet string parameter");
        System.err.println("  +param=filename       Set stylesheet document parameter");
        System.err.println("  ?param=expression     Set stylesheet parameter using XPath");
        System.err.println("  !param=value          Set serialization parameter");
        if ("".equals(message)) {
            System.exit(0);
        } else {
            System.exit(2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TransformThread
    extends Thread {
        private File outputDir;
        private Templates sheet;
        private CommandLineOptions options;
        private PrintStream traceDestination;
        private List<Source> sources;
        private int start;

        TransformThread(int i, Templates st, List<Source> s, File out, CommandLineOptions opt, PrintStream trace) {
            this.start = i;
            this.sheet = st;
            this.sources = s;
            this.options = opt;
            this.outputDir = out;
            this.traceDestination = trace;
        }

        public long getStart() {
            return this.start;
        }

        @Override
        public void run() {
            try {
                Transform.this.processDirectory(this.sources, this.sheet, this.outputDir, this.options, this.traceDestination);
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
    }
}

