#!/usr/bin/perl

package eBay::API::XML::DataType::DataElementSetType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. DataElementSetType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::DataElementSetType

=head1 DESCRIPTION

Container for a set of data elements (see below) that are applicable for a set
of products that were returned within the same response. The data elements contain
supplemental information that can help end users understand product search results.
Usage of this information is optional and may require developers to inspect
the information to determine how it can be applied in an application.
Output only.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::DataElementSetType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( [ 'DataElement', 'xs:string', '', '', '' ]
	, [ 'DataElementID', 'xs:int', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( [ 'attributeSetID', 'xs:int', '', '', '' ]
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDataElement()

An HTML snippet that specifies hints for the user, help links, help graphics,
and other supplemental information that varies per characteristic set.
In GetProductSearchPage, one DataElement value contains a hint (including an empty HTML achor element),
one DataElement value may contain a URL to insert into the HTML anchor as the href value,
and one DataElement value may contain a URL that eBay uses as a help graphic.
If no value is available in the meta-data, a dash ("--") is returned instead.
Usage of this information is optional and may require developers to inspect
the information to determine how it can be applied in an application.
Because this is returned as a string, the HTML markup elements are escaped with
character entity references (e.g.,&lt;a href=""&gt;&lt;Attributes&gt;...).
See the appendices in the eBay Web Services guide for general information about
string data types.

#    Argument: 'xs:string'

=cut

sub setDataElement {
  my $self = shift;
  $self->{'DataElement'} = shift
}

=head2 getDataElement()

  Calls: GetProductSearchPage
  Returned: Always
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:string'

=cut

sub getDataElement {
  my $self = shift;
  return $self->{'DataElement'};
}


=head2 setDataElementID()

Identifier for a data element. This is primarily for internal use by eBay.
Developers can choose to inspect this information and determine how it
can be applied in their applications.

#    Argument: 'xs:int'

=cut

sub setDataElementID {
  my $self = shift;
  $self->{'DataElementID'} = shift
}

=head2 getDataElementID()

  Calls: GetProductSearchPage
  Returned: Always
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:int'

=cut

sub getDataElementID {
  my $self = shift;
  return $self->{'DataElementID'};
}




=head2 setAttributeSetID()

Matches the AttributeSetID associated with a response
returned from the same call that returned the data element set.
As calls like GetProductSearchResults can perform batch searches, this ID helps
you determine which attribute set the data element set is associated with.

#    Argument: 'xs:int'

=cut

sub setAttributeSetID {
  my $self = shift;
  $self->{'attributeSetID'} = shift
}

=head2 getAttributeSetID()

  Calls: GetProductFamilyMembers
         GetProductSearchPage
         GetProductSearchResults
  Returned: Always
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:int'

=cut

sub getAttributeSetID {
  my $self = shift;
  return $self->{'attributeSetID'};
}



##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
