# Generated by default/object.tt
package Paws::SSM::OpsItemRelatedItemSummary;
  use Moose;
  has AssociationId => (is => 'ro', isa => 'Str');
  has AssociationType => (is => 'ro', isa => 'Str');
  has CreatedBy => (is => 'ro', isa => 'Paws::SSM::OpsItemIdentity');
  has CreatedTime => (is => 'ro', isa => 'Str');
  has LastModifiedBy => (is => 'ro', isa => 'Paws::SSM::OpsItemIdentity');
  has LastModifiedTime => (is => 'ro', isa => 'Str');
  has OpsItemId => (is => 'ro', isa => 'Str');
  has ResourceType => (is => 'ro', isa => 'Str');
  has ResourceUri => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSM::OpsItemRelatedItemSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSM::OpsItemRelatedItemSummary object:

  $service_obj->Method(Att1 => { AssociationId => $value, ..., ResourceUri => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSM::OpsItemRelatedItemSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->AssociationId

=head1 DESCRIPTION

Summary information about related-item resources for an OpsItem.

=head1 ATTRIBUTES


=head2 AssociationId => Str

The association ID.


=head2 AssociationType => Str

The association type.


=head2 CreatedBy => L<Paws::SSM::OpsItemIdentity>




=head2 CreatedTime => Str

The time the related-item association was created.


=head2 LastModifiedBy => L<Paws::SSM::OpsItemIdentity>




=head2 LastModifiedTime => Str

The time the related-item association was last updated.


=head2 OpsItemId => Str

The OpsItem ID.


=head2 ResourceType => Str

The resource type.


=head2 ResourceUri => Str

The Amazon Resource Name (ARN) of the related-item resource.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSM>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

