# Generated by default/object.tt
package Paws::AccessAnalyzer::ValidatePolicyFinding;
  use Moose;
  has FindingDetails => (is => 'ro', isa => 'Str', request_name => 'findingDetails', traits => ['NameInRequest'], required => 1);
  has FindingType => (is => 'ro', isa => 'Str', request_name => 'findingType', traits => ['NameInRequest'], required => 1);
  has IssueCode => (is => 'ro', isa => 'Str', request_name => 'issueCode', traits => ['NameInRequest'], required => 1);
  has LearnMoreLink => (is => 'ro', isa => 'Str', request_name => 'learnMoreLink', traits => ['NameInRequest'], required => 1);
  has Locations => (is => 'ro', isa => 'ArrayRef[Paws::AccessAnalyzer::Location]', request_name => 'locations', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AccessAnalyzer::ValidatePolicyFinding

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AccessAnalyzer::ValidatePolicyFinding object:

  $service_obj->Method(Att1 => { FindingDetails => $value, ..., Locations => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AccessAnalyzer::ValidatePolicyFinding object:

  $result = $service_obj->Method(...);
  $result->Att1->FindingDetails

=head1 DESCRIPTION

A finding in a policy. Each finding is an actionable recommendation
that can be used to improve the policy.

=head1 ATTRIBUTES


=head2 B<REQUIRED> FindingDetails => Str

A localized message that explains the finding and provides guidance on
how to address it.


=head2 B<REQUIRED> FindingType => Str

The impact of the finding.

Security warnings report when the policy allows access that we consider
overly permissive.

Errors report when a part of the policy is not functional.

Warnings report non-security issues when a policy does not conform to
policy writing best practices.

Suggestions recommend stylistic improvements in the policy that do not
impact access.


=head2 B<REQUIRED> IssueCode => Str

The issue code provides an identifier of the issue associated with this
finding.


=head2 B<REQUIRED> LearnMoreLink => Str

A link to additional documentation about the type of finding.


=head2 B<REQUIRED> Locations => ArrayRef[L<Paws::AccessAnalyzer::Location>]

The list of locations in the policy document that are related to the
finding. The issue code provides a summary of an issue identified by
the finding.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AccessAnalyzer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

