#!/usr/bin/perl
###########################################################################

use Test;
use Text::Scan;

BEGIN { plan tests => 1 + 1 + 1 + 1 }

my $dict = new Text::Scan;
$dict->usewild();
$dict->ignorecase();
$dict->charclass('?.!-/;: '); 
$dict->ignore("\n\r'");
$dict->ignore('#$%&()+,<=>@[\]^`{|}~');
$dict->ignore('');
$dict->ignore('');
$dict->ignore('');
$dict->ignore('');
$dict->boundary("\n\r?.!-/;: ");

ok($dict);

my $sbdict = new Text::Scan;
$sbdict->boundary('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz ');

ok($sbdict);

$dict->insert("GEs acquisition", "bingo");
$dict->insert("kg", "kg");

my @answers = $dict->scan("LBO groaned.\n\n GEs acquisition last fall");
ok($answers[0], "GEs acquisition");

@answers = $dict->scan("It appears that the explosive charge weighed over 10 kg. Shops and businesses at the site of the explosion were seriously damaged.");
ok($answers[0], "kg");

exit 0;

