use lib '.';
use strict;
use warnings;

use inc::Module::Install;

# Definition.
abstract 'Class utilities.';
author 'Michal Josef Spacek <skim@cpan.org>';
author_requires 'Cwd' => 0;
author_requires 'English' => 0;
author_requires 'File::Spec::Functions' => 0;
author_requires 'FindBin' => 0;
author_requires 'Test::More' => 0;
author_requires 'Test::NoWarnings' => 0;
author_requires 'Test::Pod' => 0;
author_requires 'Test::Pod::Coverage' => 0;
license 'bsd';
name 'Class-Utils';
readme_from 'Utils.pm';
recursive_author_tests('xt');
requires 'Error::Pure' => 0.09,
requires 'Exporter' => 0;
requires 'Readonly' => 0;
requires 'perl' => '5.8.0';
resources 'bugtracker' => 'https://rt.cpan.org/Public/Dist/Display.html'.
	'?Name=Class-Utils';
resources 'homepage' => 'https://github.com/tupinek/Class-Utils';
resources 'repository' => 'git://github.com/tupinek/Class-Utils';
test_requires 'English' => 0;
test_requires 'Test::More' => 0;
test_requires 'Test::NoWarnings' => 0;
tests_recursive;
version '0.08';

# Run.
WriteAll();
