# Generated by default/object.tt
package Paws::DMS::DocDbSettings;
  use Moose;
  has DatabaseName => (is => 'ro', isa => 'Str');
  has DocsToInvestigate => (is => 'ro', isa => 'Int');
  has ExtractDocId => (is => 'ro', isa => 'Bool');
  has KmsKeyId => (is => 'ro', isa => 'Str');
  has NestingLevel => (is => 'ro', isa => 'Str');
  has Password => (is => 'ro', isa => 'Str');
  has Port => (is => 'ro', isa => 'Int');
  has SecretsManagerAccessRoleArn => (is => 'ro', isa => 'Str');
  has SecretsManagerSecretId => (is => 'ro', isa => 'Str');
  has ServerName => (is => 'ro', isa => 'Str');
  has Username => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DMS::DocDbSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DMS::DocDbSettings object:

  $service_obj->Method(Att1 => { DatabaseName => $value, ..., Username => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DMS::DocDbSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->DatabaseName

=head1 DESCRIPTION

Provides information that defines a DocumentDB endpoint.

=head1 ATTRIBUTES


=head2 DatabaseName => Str

The database name on the DocumentDB source endpoint.


=head2 DocsToInvestigate => Int

Indicates the number of documents to preview to determine the document
organization. Use this setting when C<NestingLevel> is set to C<"one">.

Must be a positive value greater than C<0>. Default value is C<1000>.


=head2 ExtractDocId => Bool

Specifies the document ID. Use this setting when C<NestingLevel> is set
to C<"none">.

Default value is C<"false">.


=head2 KmsKeyId => Str

The AWS KMS key identifier that is used to encrypt the content on the
replication instance. If you don't specify a value for the C<KmsKeyId>
parameter, then AWS DMS uses your default encryption key. AWS KMS
creates the default encryption key for your AWS account. Your AWS
account has a different default encryption key for each AWS Region.


=head2 NestingLevel => Str

Specifies either document or table mode.

Default value is C<"none">. Specify C<"none"> to use document mode.
Specify C<"one"> to use table mode.


=head2 Password => Str

The password for the user account you use to access the DocumentDB
source endpoint.


=head2 Port => Int

The port value for the DocumentDB source endpoint.


=head2 SecretsManagerAccessRoleArn => Str

The full Amazon Resource Name (ARN) of the IAM role that specifies AWS
DMS as the trusted entity and grants the required permissions to access
the value in C<SecretsManagerSecret>. C<SecretsManagerSecret> has the
value of the AWS Secrets Manager secret that allows access to the
DocumentDB endpoint.

You can specify one of two sets of values for these permissions. You
can specify the values for this setting and C<SecretsManagerSecretId>.
Or you can specify clear-text values for C<UserName>, C<Password>,
C<ServerName>, and C<Port>. You can't specify both. For more
information on creating this C<SecretsManagerSecret> and the
C<SecretsManagerAccessRoleArn> and C<SecretsManagerSecretId> required
to access it, see Using secrets to access AWS Database Migration
Service resources
(https://docs.aws.amazon.com/https:/docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager)
in the I<AWS Database Migration Service User Guide>.


=head2 SecretsManagerSecretId => Str

The full ARN, partial ARN, or friendly name of the
C<SecretsManagerSecret> that contains the DocumentDB endpoint
connection details.


=head2 ServerName => Str

The name of the server on the DocumentDB source endpoint.


=head2 Username => Str

The user name you use to access the DocumentDB source endpoint.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DMS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

