# Generated by default/object.tt
package Paws::NetworkFirewall::StatelessRulesAndCustomActions;
  use Moose;
  has CustomActions => (is => 'ro', isa => 'ArrayRef[Paws::NetworkFirewall::CustomAction]');
  has StatelessRules => (is => 'ro', isa => 'ArrayRef[Paws::NetworkFirewall::StatelessRule]', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::NetworkFirewall::StatelessRulesAndCustomActions

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NetworkFirewall::StatelessRulesAndCustomActions object:

  $service_obj->Method(Att1 => { CustomActions => $value, ..., StatelessRules => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NetworkFirewall::StatelessRulesAndCustomActions object:

  $result = $service_obj->Method(...);
  $result->Att1->CustomActions

=head1 DESCRIPTION

Stateless inspection criteria. Each stateless rule group uses exactly
one of these data types to define its stateless rules.

=head1 ATTRIBUTES


=head2 CustomActions => ArrayRef[L<Paws::NetworkFirewall::CustomAction>]

Defines an array of individual custom action definitions that are
available for use by the stateless rules in this
C<StatelessRulesAndCustomActions> specification. You name each custom
action that you define, and then you can use it by name in your
StatelessRule RuleDefinition C<Actions> specification.


=head2 B<REQUIRED> StatelessRules => ArrayRef[L<Paws::NetworkFirewall::StatelessRule>]

Defines the set of stateless rules for use in a stateless rule group.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NetworkFirewall>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

