# Generated by default/object.tt
package Paws::FraudDetector::TrainingResult;
  use Moose;
  has DataValidationMetrics => (is => 'ro', isa => 'Paws::FraudDetector::DataValidationMetrics', request_name => 'dataValidationMetrics', traits => ['NameInRequest']);
  has TrainingMetrics => (is => 'ro', isa => 'Paws::FraudDetector::TrainingMetrics', request_name => 'trainingMetrics', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::FraudDetector::TrainingResult

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::FraudDetector::TrainingResult object:

  $service_obj->Method(Att1 => { DataValidationMetrics => $value, ..., TrainingMetrics => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::FraudDetector::TrainingResult object:

  $result = $service_obj->Method(...);
  $result->Att1->DataValidationMetrics

=head1 DESCRIPTION

The training result details.

=head1 ATTRIBUTES


=head2 DataValidationMetrics => L<Paws::FraudDetector::DataValidationMetrics>

The validation metrics.


=head2 TrainingMetrics => L<Paws::FraudDetector::TrainingMetrics>

The training metric details.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::FraudDetector>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

