/*    Unicode.xs
 *
 *    $Id: Unicode.xs,v 1.3 2001/02/11 03:27:53 bstell Exp $
 *
 *    Copyright (c) 2000 Brian Stell
 *
 *    This package is free software and is provided ``as is'' without
 *    express or implied warranty. It may be used, redistributed and/or
 *    modified under the terms of the Perl Artistic License
 *    (see http://www.perl.com/perl/misc/Artistic.html)
 *
 */

extern "C" {
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
}

#include  "picu/picu_debug.h"
#include  "picu/picu_utf8.h"
#include  "unicode/uchar.h"
#include  "unicode/unicode.h"
#include  "unicode/utf.h"

static int debugLevel = 0;

static char*
getScriptName(int scriptNum)
{
    DEBUG100("scriptNum = %d", scriptNum);
    switch(scriptNum) {
        case Unicode::kAlphabeticPresentation:
            return("kAlphabeticPresentation");
            break;
        case Unicode::kArabic:
            return("kArabic");
            break;
        case Unicode::kArabicPresentationA:
            return("kArabicPresentationA");
            break;
        case Unicode::kArabicPresentationB:
            return("kArabicPresentationB");
            break;
        case Unicode::kArmenian:
            return("kArmenian");
            break;
        case Unicode::kArrow:
            return("kArrow");
            break;
        case Unicode::kBasicLatin:
            return("kBasicLatin");
            break;
        case Unicode::kBengali:
            return("kBengali");
            break;
        case Unicode::kBlockElement:
            return("kBlockElement");
            break;
        case Unicode::kBopomofo:
            return("kBopomofo");
            break;
        case Unicode::kBoxDrawing:
            return("kBoxDrawing");
            break;
        case Unicode::kCJKCompatibility:
            return("kCJKCompatibility");
            break;
        case Unicode::kCJKCompatibilityForm:
            return("kCJKCompatibilityForm");
            break;
        case Unicode::kCJKCompatibilityIdeograph:
            return("kCJKCompatibilityIdeograph");
            break;
        case Unicode::kCJKSymbolPunctuation:
            return("kCJKSymbolPunctuation");
            break;
        case Unicode::kCJKUnifiedIdeograph:
            return("kCJKUnifiedIdeograph");
            break;
        case Unicode::kCJKUnifiedIdeographExtensionA:
            return("kCJKUnifiedIdeographExtensionA");
            break;
        case Unicode::kCombiningDiacritical:
            return("kCombiningDiacritical");
            break;
        case Unicode::kCombiningHalfMark:
            return("kCombiningHalfMark");
            break;
        case Unicode::kControlPicture:
            return("kControlPicture");
            break;
        case Unicode::kCurrencySymbolScript:
            return("kCurrencySymbolScript");
            break;
        case Unicode::kCyrillic:
            return("kCyrillic");
            break;
        case Unicode::kDevanagari:
            return("kDevanagari");
            break;
        case Unicode::kDingbat:
            return("kDingbat");
            break;
        case Unicode::kEnclosedAlphanumeric:
            return("kEnclosedAlphanumeric");
            break;
        case Unicode::kEnclosedCJKLetterMonth:
            return("kEnclosedCJKLetterMonth");
            break;
        case Unicode::kGeneralPunctuation:
            return("kGeneralPunctuation");
            break;
        case Unicode::kGeometricShape:
            return("kGeometricShape");
            break;
        case Unicode::kGeorgian:
            return("kGeorgian");
            break;
        case Unicode::kGreek:
            return("kGreek");
            break;
        case Unicode::kGreekExtended:
            return("kGreekExtended");
            break;
        case Unicode::kGujarati:
            return("kGujarati");
            break;
        case Unicode::kGurmukhi:
            return("kGurmukhi");
            break;
        case Unicode::kHalfwidthFullwidthForm:
            return("kHalfwidthFullwidthForm");
            break;
        case Unicode::kHangulCompatibilityJamo:
            return("kHangulCompatibilityJamo");
            break;
        case Unicode::kHangulJamo:
            return("kHangulJamo");
            break;
        case Unicode::kHangulSyllable:
            return("kHangulSyllable");
            break;
        case Unicode::kHebrew:
            return("kHebrew");
            break;
        case Unicode::kHighPrivateUseSurrogate:
            return("kHighPrivateUseSurrogate");
            break;
        case Unicode::kHighSurrogate:
            return("kHighSurrogate");
            break;
        case Unicode::kHiragana:
            return("kHiragana");
            break;
        case Unicode::kIdeographicDescriptionCharacters:
            return("kIdeographicDescriptionCharacters");
            break;
        case Unicode::kIPAExtension:
            return("kIPAExtension");
            break;
        case Unicode::kKanbun:
            return("kKanbun");
            break;
        case Unicode::kKangxiRadicals:
            return("kKangxiRadicals");
            break;
        case Unicode::kKannada:
            return("kKannada");
            break;
        case Unicode::kKatakana:
            return("kKatakana");
            break;
        case Unicode::kLao:
            return("kLao");
            break;
        case Unicode::kLatin1Supplement:
            return("kLatin1Supplement");
            break;
        case Unicode::kLatinExtendedA:
            return("kLatinExtendedA");
            break;
        case Unicode::kLatinExtendedAdditional:
            return("kLatinExtendedAdditional");
            break;
        case Unicode::kLatinExtendedB:
            return("kLatinExtendedB");
            break;
        case Unicode::kLetterlikeSymbol:
            return("kLetterlikeSymbol");
            break;
        case Unicode::kLowSurrogate:
            return("kLowSurrogate");
            break;
        case Unicode::kMalayalam:
            return("kMalayalam");
            break;
        case Unicode::kMathOperator:
            return("kMathOperator");
            break;
        case Unicode::kMiscSymbol:
            return("kMiscSymbol");
            break;
        case Unicode::kMiscTechnical:
            return("kMiscTechnical");
            break;
        case Unicode::kNoScript:
            return("kNoScript");
            break;
        case Unicode::kNumberForm:
            return("kNumberForm");
            break;
        case Unicode::kOpticalCharacter:
            return("kOpticalCharacter");
            break;
        case Unicode::kOriya:
            return("kOriya");
            break;
        case Unicode::kPrivateUse:
            return("kPrivateUse");
            break;
        case Unicode::kScriptCount:
            return("kScriptCount");
            break;
        case Unicode::kSmallFormVariant:
            return("kSmallFormVariant");
            break;
        case Unicode::kSpacingModifier:
            return("kSpacingModifier");
            break;
        case Unicode::kSuperSubScript:
            return("kSuperSubScript");
            break;
        case Unicode::kSymbolCombiningMark:
            return("kSymbolCombiningMark");
            break;
        case Unicode::kTamil:
            return("kTamil");
            break;
        case Unicode::kTelugu:
            return("kTelugu");
            break;
        case Unicode::kThai:
            return("kThai");
            break;
        case Unicode::kTibetan:
            return("kTibetan");
            break;
        case Unicode::kYiRadicals:
            return("kYiRadicals");
            break;
        case Unicode::kYiSyllables:
            return("kYiSyllables");
            break;
    }
    return("UNKNOWN");
}


static IV
constant_iv(char *name, int arg)
{
    errno = 0;
    DEBUG100("name = %s, arg = %d", name, arg);
    switch (*name) {

    case 'A':
        if (strEQ(name, "ARABIC_NUMBER"))
            return (Unicode::ARABIC_NUMBER);
        break;

    case 'B':
        if (strEQ(name, "BLOCK_SEPARATOR"))
            return (Unicode::BLOCK_SEPARATOR);
        if (strEQ(name, "BOUNDARY_NEUTRAL"))
            return (Unicode::BOUNDARY_NEUTRAL);
        break;

    case 'C':
        if (strEQ(name, "COMBINING_SPACING_MARK"))
            return (Unicode::COMBINING_SPACING_MARK);
        if (strEQ(name, "COMMON_NUMBER_SEPARATOR"))
            return (Unicode::COMMON_NUMBER_SEPARATOR);
        if (strEQ(name, "CONNECTOR_PUNCTUATION"))
            return (Unicode::CONNECTOR_PUNCTUATION);
        if (strEQ(name, "CONTROL"))
            return (Unicode::CONTROL);
        if (strEQ(name, "CURRENCY_SYMBOL"))
            return (Unicode::CURRENCY_SYMBOL);
        break;

    case 'D':
        if (strEQ(name, "DASH_PUNCTUATION"))
            return (Unicode::DASH_PUNCTUATION);
        if (strEQ(name, "DECIMAL_DIGIT_NUMBER"))
            return (Unicode::DECIMAL_DIGIT_NUMBER);
        if (strEQ(name, "DIR_NON_SPACING_MARK"))
            return (Unicode::DIR_NON_SPACING_MARK);
        break;

    case 'E':
        if (strEQ(name, "ENCLOSING_MARK"))
            return (Unicode::ENCLOSING_MARK);
        if (strEQ(name, "END_PUNCTUATION"))
            return (Unicode::END_PUNCTUATION);
        if (strEQ(name, "EUROPEAN_NUMBER"))
            return (Unicode::EUROPEAN_NUMBER);
        if (strEQ(name, "EUROPEAN_NUMBER_SEPARATOR"))
            return (Unicode::EUROPEAN_NUMBER_SEPARATOR);
        if (strEQ(name, "EUROPEAN_NUMBER_TERMINATOR"))
            return (Unicode::EUROPEAN_NUMBER_TERMINATOR);
        break;

    case 'F':
        if (strEQ(name, "FINAL_PUNCTUATION"))
            return (Unicode::FINAL_PUNCTUATION);
        if (strEQ(name, "FORMAT"))
            return (Unicode::FORMAT);
        if (strEQ(name, "FULL_WIDTH"))
            return (Unicode::FULL_WIDTH);
        break;

    case 'G':
        if (strEQ(name, "GENERAL_TYPES_COUNT"))
            return (Unicode::GENERAL_TYPES_COUNT);
        break;

    case 'H':
        if (strEQ(name, "HALF_WIDTH"))
            return (Unicode::HALF_WIDTH);
        break;

    case 'I':
        if (strEQ(name, "INITIAL_PUNCTUATION"))
            return (Unicode::INITIAL_PUNCTUATION);
        break;

    case 'k':
        if (!(*(name+1))) {
            goto not_there;
        }
        switch (*(name+1)) {

            case 'A':
                if (strEQ(name, "kAlphabeticPresentation"))
                    return (Unicode::kAlphabeticPresentation);
                if (strEQ(name, "kArabic"))
                    return (Unicode::kArabic);
                if (strEQ(name, "kArabicPresentationA"))
                    return (Unicode::kArabicPresentationA);
                if (strEQ(name, "kArabicPresentationB"))
                    return (Unicode::kArabicPresentationB);
                if (strEQ(name, "kArmenian"))
                    return (Unicode::kArmenian);
                if (strEQ(name, "kArrow"))
                    return (Unicode::kArrow);
                break;

            case 'B':
                if (strEQ(name, "kBasicLatin"))
                    return (Unicode::kBasicLatin);
                if (strEQ(name, "kBengali"))
                    return (Unicode::kBengali);
                if (strEQ(name, "kBlockElement"))
                    return (Unicode::kBlockElement);
                if (strEQ(name, "kBopomofo"))
                    return (Unicode::kBopomofo);
                if (strEQ(name, "kBoxDrawing"))
                    return (Unicode::kBoxDrawing);
                break;

            case 'C':
                if (strEQ(name, "kCJKCompatibility"))
                    return (Unicode::kCJKCompatibility);
                if (strEQ(name, "kCJKCompatibilityForm"))
                    return (Unicode::kCJKCompatibilityForm);
                if (strEQ(name, "kCJKCompatibilityIdeograph"))
                    return (Unicode::kCJKCompatibilityIdeograph);
                if (strEQ(name, "kCJKSymbolPunctuation"))
                    return (Unicode::kCJKSymbolPunctuation);
                if (strEQ(name, "kCJKUnifiedIdeograph"))
                    return (Unicode::kCJKUnifiedIdeograph);
                if (strEQ(name, "kCJKUnifiedIdeographsExtensionA"))
                    return (Unicode::kCJKUnifiedIdeographExtensionA);
                if (strEQ(name, "kCombiningDiacritical"))
                    return (Unicode::kCombiningDiacritical);
                if (strEQ(name, "kCombiningHalfMark"))
                    return (Unicode::kCombiningHalfMark);
                if (strEQ(name, "kControlPicture"))
                    return (Unicode::kControlPicture);
                if (strEQ(name, "kCurrencySymbolScript"))
                    return (Unicode::kCurrencySymbolScript);
                if (strEQ(name, "kCyrillic"))
                    return (Unicode::kCyrillic);
                break;

            case 'D':
                if (strEQ(name, "kDevanagari"))
                    return (Unicode::kDevanagari);
                if (strEQ(name, "kDingbat"))
                    return (Unicode::kDingbat);
                break;

            case 'E':
                if (strEQ(name, "kEnclosedAlphanumeric"))
                    return (Unicode::kEnclosedAlphanumeric);
                if (strEQ(name, "kEnclosedCJKLetterMonth"))
                    return (Unicode::kEnclosedCJKLetterMonth);
                break;

            case 'G':
                if (strEQ(name, "kGeneralPunctuation"))
                    return (Unicode::kGeneralPunctuation);
                if (strEQ(name, "kGeometricShape"))
                    return (Unicode::kGeometricShape);
                if (strEQ(name, "kGeorgian"))
                    return (Unicode::kGeorgian);
                if (strEQ(name, "kGreek"))
                    return (Unicode::kGreek);
                if (strEQ(name, "kGreekExtended"))
                    return (Unicode::kGreekExtended);
                if (strEQ(name, "kGujarati"))
                    return (Unicode::kGujarati);
                if (strEQ(name, "kGurmukhi"))
                    return (Unicode::kGurmukhi);
                break;

            case 'H':
                if (strEQ(name, "kHalfwidthFullwidthForm"))
                    return (Unicode::kHalfwidthFullwidthForm);
                if (strEQ(name, "kHangulCompatibilityJamo"))
                    return (Unicode::kHangulCompatibilityJamo);
                if (strEQ(name, "kHangulJamo"))
                    return (Unicode::kHangulJamo);
                if (strEQ(name, "kHangulSyllable"))
                    return (Unicode::kHangulSyllable);
                if (strEQ(name, "kHebrew"))
                    return (Unicode::kHebrew);
                if (strEQ(name, "kHighPrivateUseSurrogate"))
                    return (Unicode::kHighPrivateUseSurrogate);
                if (strEQ(name, "kHighSurrogate"))
                    return (Unicode::kHighSurrogate);
                if (strEQ(name, "kHiragana"))
                    return (Unicode::kHiragana);
                break;

            case 'I':
                if (strEQ(name, "kIdeographicDescriptionCharacters"))
                    return (Unicode::kIdeographicDescriptionCharacters);
                if (strEQ(name, "kIPAExtension"))
                    return (Unicode::kIPAExtension);
                break;

            case 'K':
                if (strEQ(name, "kKanbun"))
                    return (Unicode::kKanbun);
                if (strEQ(name, "kKangxiRadicals"))
                    return (Unicode::kKangxiRadicals);
                if (strEQ(name, "kKannada"))
                    return (Unicode::kKannada);
                if (strEQ(name, "kKatakana"))
                    return (Unicode::kKatakana);
                break;

            case 'L':
                if (strEQ(name, "kLao"))
                    return (Unicode::kLao);
                if (strEQ(name, "kLatin1Supplement"))
                    return (Unicode::kLatin1Supplement);
                if (strEQ(name, "kLatinExtendedA"))
                    return (Unicode::kLatinExtendedA);
                if (strEQ(name, "kLatinExtendedAdditional"))
                    return (Unicode::kLatinExtendedAdditional);
                if (strEQ(name, "kLatinExtendedB"))
                    return (Unicode::kLatinExtendedB);
                if (strEQ(name, "kLetterlikeSymbol"))
                    return (Unicode::kLetterlikeSymbol);
                if (strEQ(name, "kLowSurrogate"))
                    return (Unicode::kLowSurrogate);
                break;

            case 'M':
                if (strEQ(name, "kMalayalam"))
                    return (Unicode::kMalayalam);
                if (strEQ(name, "kMathOperator"))
                    return (Unicode::kMathOperator);
                if (strEQ(name, "kMiscSymbol"))
                    return (Unicode::kMiscSymbol);
                if (strEQ(name, "kMiscTechnical"))
                    return (Unicode::kMiscTechnical);
                break;

            case 'N':
                if (strEQ(name, "kNoScript"))
                    return (Unicode::kNoScript);
                if (strEQ(name, "kNumberForm"))
                    return (Unicode::kNumberForm);
                break;

            case 'O':
                if (strEQ(name, "kOpticalCharacter"))
                    return (Unicode::kOpticalCharacter);
                if (strEQ(name, "kOriya"))
                    return (Unicode::kOriya);
                break;

            case 'P':
                if (strEQ(name, "kPrivateUse"))
                    return (Unicode::kPrivateUse);
                break;

            case 'S':
                if (strEQ(name, "kScriptCount"))
                    return (Unicode::kScriptCount);
                if (strEQ(name, "kSmallFormVariant"))
                    return (Unicode::kSmallFormVariant);
                if (strEQ(name, "kSpacingModifier"))
                    return (Unicode::kSpacingModifier);
                if (strEQ(name, "kSuperSubScript"))
                    return (Unicode::kSuperSubScript);
                if (strEQ(name, "kSymbolCombiningMark"))
                    return (Unicode::kSymbolCombiningMark);
                break;

            case 'T':
                if (strEQ(name, "kTamil"))
                    return (Unicode::kTamil);
                if (strEQ(name, "kTelugu"))
                    return (Unicode::kTelugu);
                if (strEQ(name, "kThai"))
                    return (Unicode::kThai);
                if (strEQ(name, "kTibetan"))
                    return (Unicode::kTibetan);
                break;
            case 'Y':
                if (strEQ(name, "kYiRadicals"))
                    return (Unicode::kYiRadicals);
                if (strEQ(name, "kYiSyllables"))
                    return (Unicode::kYiSyllables);
                break;
        }
        break;

    case 'L':
        if (strEQ(name, "LEFT_TO_RIGHT"))
            return (Unicode::LEFT_TO_RIGHT);
        if (strEQ(name, "LEFT_TO_RIGHT_EMBEDDING"))
            return (Unicode::LEFT_TO_RIGHT_EMBEDDING);
        if (strEQ(name, "LEFT_TO_RIGHT_OVERRIDE"))
            return (Unicode::LEFT_TO_RIGHT_OVERRIDE);
        if (strEQ(name, "LETTER_NUMBER"))
            return (Unicode::LETTER_NUMBER);
        if (strEQ(name, "LINE_SEPARATOR"))
            return (Unicode::LINE_SEPARATOR);
        if (strEQ(name, "LOWERCASE_LETTER"))
            return (Unicode::LOWERCASE_LETTER);
        break;

    case 'M':
        if (strEQ(name, "MATH_SYMBOL"))
            return (Unicode::MATH_SYMBOL);
        if (strEQ(name, "MAX_CHAR_LENGTH"))
            return (Unicode::MAX_CHAR_LENGTH);
        if (strEQ(name, "MAX_RADIX"))
            return (Unicode::MAX_RADIX);
        if (strEQ(name, "MAX_VALUE"))
            return (Unicode::MAX_VALUE);
        if (strEQ(name, "MIN_RADIX"))
            return (Unicode::MIN_RADIX);
        if (strEQ(name, "MIN_VALUE"))
            return (Unicode::MIN_VALUE);
        if (strEQ(name, "MODIFIER_LETTER"))
            return (Unicode::MODIFIER_LETTER);
        if (strEQ(name, "MODIFIER_SYMBOL"))
            return (Unicode::MODIFIER_SYMBOL);
        break;

    case 'N':
        if (strEQ(name, "NEUTRAL"))
            return (Unicode::NEUTRAL);
        if (strEQ(name, "NON_SPACING_MARK"))
            return (Unicode::NON_SPACING_MARK);
        break;

    case 'O':
        if (strEQ(name, "OTHER_LETTER"))
            return (Unicode::OTHER_LETTER);
        if (strEQ(name, "OTHER_NEUTRAL"))
            return (Unicode::OTHER_NEUTRAL);
        if (strEQ(name, "OTHER_NUMBER"))
            return (Unicode::OTHER_NUMBER);
        if (strEQ(name, "OTHER_PUNCTUATION"))
            return (Unicode::OTHER_PUNCTUATION);
        if (strEQ(name, "OTHER_SYMBOL"))
            return (Unicode::OTHER_SYMBOL);
        break;

    case 'P':
        if (strEQ(name, "PARAGRAPH_SEPARATOR"))
            return (Unicode::PARAGRAPH_SEPARATOR);
        if (strEQ(name, "POP_DIRECTIONAL_FORMAT"))
            return (Unicode::POP_DIRECTIONAL_FORMAT);
        if (strEQ(name, "PRIVATE_USE"))
            return (Unicode::PRIVATE_USE);
        break;

    case 'R':
        if (strEQ(name, "RIGHT_TO_LEFT"))
            return (Unicode::RIGHT_TO_LEFT);
        if (strEQ(name, "RIGHT_TO_LEFT_ARABIC"))
            return (Unicode::RIGHT_TO_LEFT_ARABIC);
        if (strEQ(name, "RIGHT_TO_LEFT_EMBEDDING"))
            return (Unicode::RIGHT_TO_LEFT_EMBEDDING);
        if (strEQ(name, "RIGHT_TO_LEFT_OVERRIDE"))
            return (Unicode::RIGHT_TO_LEFT_OVERRIDE);
        break;

    case 'S':
        if (strEQ(name, "SPACE_SEPARATOR"))
            return (Unicode::SPACE_SEPARATOR);
        if (strEQ(name, "START_PUNCTUATION"))
            return (Unicode::START_PUNCTUATION);
        if (strEQ(name, "SEGMENT_SEPARATOR"))
            return (Unicode::SEGMENT_SEPARATOR);
        if (strEQ(name, "SURROGATE"))
            return (Unicode::SURROGATE);
        break;

    case 'T':
        if (strEQ(name, "TITLECASE_LETTER"))
            return (Unicode::TITLECASE_LETTER);
        break;

    case 'U':
        if (strEQ(name, "UNASSIGNED"))
            return (Unicode::UNASSIGNED);
        if (strEQ(name, "UPPERCASE_LETTER"))
            return (Unicode::UPPERCASE_LETTER);
        break;

    case 'W':
        if (strEQ(name, "WHITE_SPACE_NEUTRAL"))
            return (Unicode::WHITE_SPACE_NEUTRAL);
        break;

    case 'Z':
        if (strEQ(name, "ZERO_WIDTH"))
            return (Unicode::ZERO_WIDTH);
        break;

    }
    errno = EINVAL;
    return 0;

/* if a value should be defined but is not */
not_there:
    errno = ENOENT;
    return 0;
}

typedef enum Unicode::EUnicodeGeneralTypes Unicode__EUnicodeGeneralTypes;
typedef enum Unicode::EUnicodeScript Unicode__EUnicodeScript;
typedef enum Unicode::EDirectionProperty Unicode__EDirectionProperty;
typedef enum Unicode::ECellWidths Unicode__ECellWidths;

MODULE = ICU::Unicode    PACKAGE = ICU::Unicode  

# This requires xsubpp version 1.925 or greater
REQUIRE: 1.925

IV
constant_iv(name, arg)
    char *name
    int arg

char*
getScriptName(scriptNum)
        int scriptNum;
    CODE:
        RETVAL = getScriptName(scriptNum);
    OUTPUT:
        RETVAL

unsigned int
getCellWidth(CLASS, u8char)
        char *CLASS;
        char *u8char;
    PREINIT:
        UChar32 u32char;
        int i = 0;
        int x;
    CODE:
        UTF8_NEXT_CHAR_SAFE((const uint8_t *)u8char, i, strlen(u8char), u32char, 1);
        x = Unicode::getCellWidth(u32char);
        RETVAL = x;
    OUTPUT:
        RETVAL

Unicode__EUnicodeScript
getScript(CLASS, u8char)
        char *CLASS;
        char *u8char;
    PREINIT:
        UChar32 u32char;
        int i = 0;
        int x;
    CODE:
        UTF8_NEXT_CHAR_SAFE((const uint8_t *)u8char, i, strlen(u8char), u32char, 1);
        DEBUG100("u32char = %lx", u32char);
        IF_DEBUG100 dump_U8StringAsHex((const U8 *)u8char);
        IF_DEBUG100 dump_U8String((const U8 *)u8char);
        RETVAL = Unicode::getScript(u32char);
        DEBUG100("RETVAL = %d", RETVAL);
    OUTPUT:
        RETVAL

int
setDebugLevel(...)
    CODE:
        RETVAL = debugLevel; // return old value
        if (items > 1) {
            Perl_croak(aTHX_ "Usage: ICU::DateFormat::setDebugLevel([new_debug_level])");
        }
        else if (items == 1) {
            debugLevel = SvIV(ST(0));
        }
        DEBUG100("debugLevel = %d", debugLevel);
    OUTPUT:
        RETVAL

