# Generated by default/object.tt
package Paws::LexRuntimeV2::Interpretation;
  use Moose;
  has Intent => (is => 'ro', isa => 'Paws::LexRuntimeV2::Intent', request_name => 'intent', traits => ['NameInRequest']);
  has NluConfidence => (is => 'ro', isa => 'Paws::LexRuntimeV2::ConfidenceScore', request_name => 'nluConfidence', traits => ['NameInRequest']);
  has SentimentResponse => (is => 'ro', isa => 'Paws::LexRuntimeV2::SentimentResponse', request_name => 'sentimentResponse', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexRuntimeV2::Interpretation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexRuntimeV2::Interpretation object:

  $service_obj->Method(Att1 => { Intent => $value, ..., SentimentResponse => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexRuntimeV2::Interpretation object:

  $result = $service_obj->Method(...);
  $result->Att1->Intent

=head1 DESCRIPTION

An intent that Amazon Lex V2 determined might satisfy the user's
utterance. The intents are ordered by the confidence score.

=head1 ATTRIBUTES


=head2 Intent => L<Paws::LexRuntimeV2::Intent>

A list of intents that might satisfy the user's utterance. The intents
are ordered by the confidence score.


=head2 NluConfidence => L<Paws::LexRuntimeV2::ConfidenceScore>

Determines the threshold where Amazon Lex V2 will insert the
C<AMAZON.FallbackIntent>, C<AMAZON.KendraSearchIntent>, or both when
returning alternative intents in a response. C<AMAZON.FallbackIntent>
and C<AMAZON.KendraSearchIntent> are only inserted if they are
configured for the bot.


=head2 SentimentResponse => L<Paws::LexRuntimeV2::SentimentResponse>

The sentiment expressed in an utterance.

When the bot is configured to send utterances to Amazon Comprehend for
sentiment analysis, this field contains the result of the analysis.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexRuntimeV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

