# Generated by default/object.tt
package Paws::MediaLive::AudioSilenceFailoverSettings;
  use Moose;
  has AudioSelectorName => (is => 'ro', isa => 'Str', request_name => 'audioSelectorName', traits => ['NameInRequest'], required => 1);
  has AudioSilenceThresholdMsec => (is => 'ro', isa => 'Int', request_name => 'audioSilenceThresholdMsec', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaLive::AudioSilenceFailoverSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaLive::AudioSilenceFailoverSettings object:

  $service_obj->Method(Att1 => { AudioSelectorName => $value, ..., AudioSilenceThresholdMsec => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaLive::AudioSilenceFailoverSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->AudioSelectorName

=head1 DESCRIPTION

Placeholder documentation for AudioSilenceFailoverSettings

=head1 ATTRIBUTES


=head2 B<REQUIRED> AudioSelectorName => Str

The name of the audio selector in the input that MediaLive should
monitor to detect silence. Select your most important rendition. If you
didn't create an audio selector in this input, leave blank.


=head2 AudioSilenceThresholdMsec => Int

The amount of time (in milliseconds) that the active input must be
silent before automatic input failover occurs. Silence is defined as
audio loss or audio quieter than -50 dBFS.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaLive>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

