# Generated by default/object.tt
package Paws::Connect::IntegrationAssociationSummary;
  use Moose;
  has InstanceId => (is => 'ro', isa => 'Str');
  has IntegrationArn => (is => 'ro', isa => 'Str');
  has IntegrationAssociationArn => (is => 'ro', isa => 'Str');
  has IntegrationAssociationId => (is => 'ro', isa => 'Str');
  has IntegrationType => (is => 'ro', isa => 'Str');
  has SourceApplicationName => (is => 'ro', isa => 'Str');
  has SourceApplicationUrl => (is => 'ro', isa => 'Str');
  has SourceType => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Connect::IntegrationAssociationSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Connect::IntegrationAssociationSummary object:

  $service_obj->Method(Att1 => { InstanceId => $value, ..., SourceType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Connect::IntegrationAssociationSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->InstanceId

=head1 DESCRIPTION

Contains summary information about the associated AppIntegrations.

=head1 ATTRIBUTES


=head2 InstanceId => Str

The identifier of the Amazon Connect instance. You can find the
instanceId in the ARN of the instance.


=head2 IntegrationArn => Str

The Amazon Resource Name (ARN) for the AppIntegration.


=head2 IntegrationAssociationArn => Str

The Amazon Resource Name (ARN) for the AppIntegration association.


=head2 IntegrationAssociationId => Str

The identifier for the AppIntegration association.


=head2 IntegrationType => Str

The integration type.


=head2 SourceApplicationName => Str

The user-provided, friendly name for the external application.


=head2 SourceApplicationUrl => Str

The URL for the external application.


=head2 SourceType => Str

The name of the source.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Connect>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

