
%{
/*                                                                
**  Copyright (C) 2007,2010  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 3 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */


#include <string.h>
#include <stdlib.h>

#include <pargs.h>
#include "pfile.h"
#include "putil.h"
#include "iarg.h"
#include "iraf.h"

static void iarg_error(char const *s); 

static ParamList *result;
static ParamList *reference;
static int	  position;
int t_valu;

#define MODE 3

#define YYINITDEPTH 256
#define YYMAXDEPTH  257

/* This is the bit eric told me about.
 */
static char nstr[1];
%}

%token <stri>	T_valu
%token <stri>	T_name
%token <stri>	T_mark
%token <stri>	T_posi

%union {
	ParamList	*plist;
	char		*stri;
}


%type <plist>	pfile
%type <plist>	plist

%%

pfile	: plist
		{ result = $$;	}
	;


plist	: T_posi
		{ 
		  if ( reference == 0 ) {
			parerr = PARNOREFR;
			return 1;
		  }

		  $$ = PListAdd(NULL
		   , ParamPositional(reference, position++, $1));

		  if ( $$ == NULL ) return 1;
		}
	| plist T_posi
		{ 
		  if ( reference == 0 ) {
			parerr = PARNOREFR;
			return 1;
		  }

		  $$ = PListAdd($1
		   , ParamPositional(reference, position++, $2));
		  if ( $$ == 0 ) return 1;
		}
	| T_name '='
		{ 		int mode;
		  mode = QMODE;
		  $$ = PListAdd(NULL
		   , ParamCreate(ParamMatch(reference, $1)
				 , StringType, &mode, strdup(nstr), NULL));
		  if ( $$ == 0 ) return 1;
		}
	| plist T_name '='
		{  		int mode;
		  mode = QMODE;
		  $$ = PListAdd($1
		   , ParamCreate(ParamMatch(reference, $2)
				 , StringType, &mode, strdup(nstr), NULL));
		  if ( $$ == 0 ) return 1;
		}
	| T_name T_mark
		{  		int mode;
		  mode = LMODE;
		  $$ = PListAdd(NULL
		   , ParamCreate(ParamMatch(reference, $1)
				 , StringType, &mode, $2, NULL));
		  if ( $$ == 0 ) return 1;
		}
	| plist T_name T_mark
		{  		int mode;
		  mode = LMODE;
		  $$ = PListAdd($1
		   , ParamCreate(ParamMatch(reference, $2)
				 , StringType, &mode, $3, NULL));
		  if ( $$ == NULL ) return 1;
		}
	| T_name '=' T_valu
		{  		int mode;
		  mode = LMODE;

		  $$ = PListAdd(NULL
		   , ParamCreate(ParamMatch(reference, $1)
				 , StringType, &mode, $3, NULL));
		  if ( $$ == 0 ) return 1;
		}
	| plist T_name '=' T_valu
		{  		int mode;
		  mode = LMODE;
		  $$ = PListAdd($1
				, ParamCreate(ParamMatch(reference, $2)
				  , StringType, &mode, $4, NULL));
		  if ( $$ == 0 ) return 1;
		}
	;
%%

ParamList *IRAFParArgs(ParamList *plist, char *argv[], int argc )
{
		extern FILE *iarg_in;

		static int parser = 0;

/*		extern yydebug;

	yydebug = 1;
*/
	*nstr = '\0';

	result	= 0;
	reference	= plist;
	position	= 1;
	t_valu		= T_posi;

	if ( parser )
	    iarg_restart( (FILE *) OpenArgv(0, '\001', argv, argc));
	else {
		iarg_in = (FILE *) OpenArgv(0, '\001', argv, argc);
		parser = 1;
	}


	if ( iarg_parse() ) {
		PFree(result);
		result = 0;
	} else {
	    result->file     = NULL;
	    result->filename = NULL;
	    result->psetname = NULL;
	}

	CloseArgv((ArgStream) iarg_in);


	return result;		
}

void
iarg_error(char const *s)
{
	fprintf(stderr, "Sorry, Arguments not ok, try again.\n");
}
