# Generated by default/object.tt
package Paws::RDS::DBProxyEndpoint;
  use Moose;
  has CreatedDate => (is => 'ro', isa => 'Str');
  has DBProxyEndpointArn => (is => 'ro', isa => 'Str');
  has DBProxyEndpointName => (is => 'ro', isa => 'Str');
  has DBProxyName => (is => 'ro', isa => 'Str');
  has Endpoint => (is => 'ro', isa => 'Str');
  has IsDefault => (is => 'ro', isa => 'Bool');
  has Status => (is => 'ro', isa => 'Str');
  has TargetRole => (is => 'ro', isa => 'Str');
  has VpcId => (is => 'ro', isa => 'Str');
  has VpcSecurityGroupIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has VpcSubnetIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::RDS::DBProxyEndpoint

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::RDS::DBProxyEndpoint object:

  $service_obj->Method(Att1 => { CreatedDate => $value, ..., VpcSubnetIds => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::RDS::DBProxyEndpoint object:

  $result = $service_obj->Method(...);
  $result->Att1->CreatedDate

=head1 DESCRIPTION

The data structure representing an endpoint associated with a DB proxy.
RDS automatically creates one endpoint for each DB proxy. For Aurora DB
clusters, you can associate additional endpoints with the same DB
proxy. These endpoints can be read/write or read-only. They can also
reside in different VPCs than the associated DB proxy.

This data type is used as a response element in the
C<DescribeDBProxyEndpoints> operation.

=head1 ATTRIBUTES


=head2 CreatedDate => Str

The date and time when the DB proxy endpoint was first created.


=head2 DBProxyEndpointArn => Str

The Amazon Resource Name (ARN) for the DB proxy endpoint.


=head2 DBProxyEndpointName => Str

The name for the DB proxy endpoint. An identifier must begin with a
letter and must contain only ASCII letters, digits, and hyphens; it
can't end with a hyphen or contain two consecutive hyphens.


=head2 DBProxyName => Str

The identifier for the DB proxy that is associated with this DB proxy
endpoint.


=head2 Endpoint => Str

The endpoint that you can use to connect to the DB proxy. You include
the endpoint value in the connection string for a database client
application.


=head2 IsDefault => Bool

A value that indicates whether this endpoint is the default endpoint
for the associated DB proxy. Default DB proxy endpoints always have
read/write capability. Other endpoints that you associate with the DB
proxy can be either read/write or read-only.


=head2 Status => Str

The current status of this DB proxy endpoint. A status of C<available>
means the endpoint is ready to handle requests. Other values indicate
that you must wait for the endpoint to be ready, or take some action to
resolve an issue.


=head2 TargetRole => Str

A value that indicates whether the DB proxy endpoint can be used for
read/write or read-only operations.


=head2 VpcId => Str

Provides the VPC ID of the DB proxy endpoint.


=head2 VpcSecurityGroupIds => ArrayRef[Str|Undef]

Provides a list of VPC security groups that the DB proxy endpoint
belongs to.


=head2 VpcSubnetIds => ArrayRef[Str|Undef]

The EC2 subnet IDs for the DB proxy endpoint.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::RDS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

