use strict;
use warnings;
use Test::More tests => 68;
use Digest::SIMD qw(simd_256 simd_256_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::SIMD->new(256)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            simd_256_hex($data), $digest,
            "simd_256_hex: $len bits of $msg"
        );
        ok(
            simd_256($data) eq pack('H*', $digest),
            "simd_256: $len bits of $msg"
        );
    }

    my $md = Digest::SIMD->new(256)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $msg");
}
continue { $len++ }

__DATA__
00|8029E81E7320E13ED9001DC3D8021FEC695B7A25CD43AD805260181C35FCAEA8
00|35D550C798F3D4AB2FF939EA2E433673FDC0601EC3AC33BA9C5141AC35958FE2
C0|15058270BF239BE894C3A80D75B66B13ED126EFF6946288AAAA84E0E2868D796
C0|CC224EBC8F80AD00720D65EBC7AB8D4F5B331C40C14D2755869A5AA3774B8D29
80|6FDFE327B5A8EBFDBC585A200E323773D29FB2EDC1E272C5F4B7496BC396401B
48|3F97B7D917BEB90713659EFDC0DA268817011F425F2BD29850EC199D1402C2FB
50|A32B0F4B3D9E6C6DEA59238D8F74C603D82DCE3A7162DA71433F0F66027346F4
98|33FADAAC0A8206A298B71875744ACD5FC9ECDF3380E86361F8B1CC50BC62FC7E
CC|4ACB11B332C3CB462B60EBBB0DEC32EF7A2A3470AF49EC5C10AA52A484A640D4
9800|3C885A8AA14F92FBF153A2EDC3DD01E91D39D7651BA4C9539C443C5E626CE0EC
9D40|A0E1767461DDB92DAD5DB0109BCF23818AD0E3E4C8D84DC589C552804819FB3A
AA80|624BE1103CF32A1F4034F46E2925225829460D75449047633D952F69140A4FED
9830|7753A223DA8AC2CFF6DB86C0908DB3D4AD120D5B9E2FBFA917F91594EBD1ED7D
5030|923175E84B95758DB9ED009ABC15859434338D2D6D1FD207DD90C7F0F9778D98
4D24|2EACFF42D0E825518CC32DF851B3F19C6C98FA8A3F55C7AE9072090934C590C8
CBDE|B5733B44566EB61B47167273C8FCED1E7ED608D82E860BAB2F36EF1458CA445C
41FB|4FD086605090C098EC99640723B3E46CE797ADA52EDF8A96B50500E0306E4EEA
4FF400|3A01C479460AAA2DDF3017C5C7CF9596A3BBDEF7FB98F72C931F71CCBCD88B26
FD0440|471C6259384B5BC8EB96E857F4822A00A829F2D3FFA504C976099424A71FCAD8
424D00|12722324E2DC5F3B1F0382318F3F4DA12924799452F4E414A6A8900C9E4D69F2
3FDEE0|E42F656D519E9496228B141D3F1ADDF05A7165773FDA855F6CB445E4B84F3AE6
335768|F8D4F06DA3FD1C9F2AD3B43417B6C994028E657B969735A3880EFED0B38F50AA
051E7C|C7EC8E9CD0AD4C116746B3090CFCF1B3E568544E3E4BF24498C35B4FA2AEBF36
717F8C|198F3B710D76E295367D64B0FB447DACDC0EB67E0E00CEC85F5F9B6AE0A91B6D
1F877C|42A770E206A956289532677562FAC28D19249B9FAE54D4E595494A2E4E15AEC4
EB35CF80|E3BAEB7A6A05714693F648B5C515C436B9F5C0EBA0551DDA89E50A5A9A3D9293
B406C480|B35760BE8B9CDF83AB29A87CEC7F6DDE1782BE128E040596CFF64B0B44AF0005
CEE88040|C5A1BDED30DC0A46852EFA0C01213AAD23AB684430DE6E8B032860141999788B
C584DB70|B81605B9E1DDCDADB5AC3F4C398308A1F0FEB7DA7854BB7A9BA1855200D4337A
53587BC8|898F54F013EF782015F75212D9F8E722D479EB82A926C968F8131FB22A676E1A
69A305B0|217A1A10D0F95F570C88F33A577A692A279E8C0DA04E78003228341C4606B7D0
C9375ECE|7656FE604F85B2514D212BB2D6EB94B7954B7614B545BDF64DEFDF29427B00D7
C1ECFDFC|A97BE3876200AA03E5DCC12F2C78ABF9E7F0C456E968B2A3D747B3986D4DB871
8D73E8A280|C7AE0C4BC478A1876F3591954211A510F748EA988E540930AED3C9284AAF7DF7
06F2522080|42B48367BE2BF6D1A3A97953730FE72E5357FEFC120459916E53C08F0B71BE2D
3EF6C36F20|4E868A9EEC03975AB4B2AFAE062EFC1A256A6C88BD3C42467A9DE3FF307A3206
0127A1D340|3055A0E0D43653B786FA43F043EEBE1B1695498C24617265C30F317A57182209
6A6AB6C210|2628B2797011DFFA02F808F65D87B0515D81D9D2CF9CAEE02F8F5CDA34446EF2
AF3175E160|BFEF64CA99200DEBD8F2B866133A4270B7A121E44F267447988E9E5C7CE6031D
B66609ED86|0CCFFDF9C9B9B0A1B5C08F9683734A48BE69B4671E57BE3EFD9514507E62FF5E
21F134AC57|A1CC7E4E4D5D397570CDF211FB2CF1C96AF4FF17E035892F71920E6252F2359F
3DC2AADFFC80|0AE1892FEEAD126E8F2E450E387A40741F1D0B5C374B84BE2ECF86DE5511152E
9202736D2240|D1CC0D7C783988CF29636AC8A2CDFB7FE77FADFE614FD12186A331E6DE661A87
F219BD629820|0A6D5AC61CC4F6DB4F571BCAE0CDB1E2A372247DF8CC4E5D5641BC2D4BB38455
F3511EE2C4B0|D859B35810FB320452C8E21FDD167A627580E55FB00A7600DB95B75B657E9947
3ECAB6BF7720|F1279AD51AECA156C0ADCF717A4BAFB7C0795E52CDEFDC045F8F8D5DC8D480F4
CD62F688F498|AE9424056258B2FB11BF67F29D81607E3BBB61A631AFE297749913F37D10EC20
C2CBAA33A9F8|6C6C415F64FD0A0BC5A8237D637E25BA8D94D007AD0857B650C0FF9F918C11E0
C6F50BB74E29|895416829907653335EE9130A2182EA11A031550BA270B9970BBF1E7A68D7CB6
79F1B4CCC62A00|2EE17EBA947F940D6A2DBF1D3FA56AA24381A142E0BC39E10DC05ACD497ABF84
