package Net::Kubernetes::Resource::State;
$Net::Kubernetes::Resource::State::VERSION = '0.04';
use Moose::Role;

=head1 NAME

Net::Kubernetes::Resource::State

=head1 VERSION

version 0.04

=cut


has status => (
	is       => 'rw',
	isa      => 'HashRef',
	required => 1
);

sub refresh {
	my($self) = @_;
	my($res) = $self->ua->request($self->create_request(GET => $self->url.'/'.$self->base_path));
	if ($res->is_success) {
		my($data) = $self->json->decode($res->content);
		$self->status($data->{status});
		return 1;
	}
	return 0;
}

return 42;
