#!/usr/bin/env perl

use strict;
use warnings;

use Test::More tests => 6;
use Set::Functional qw{:all};

#Predeclarations
sub get_arr_different_sizes();
sub get_cartesian_arr_different_sizes();
sub get_cartesian_arr_nums();

my @arr_num1 = (1 .. 10);
my @arr_num2 = (6 .. 15);
my @arr_num3 = map { $_ * 2 } (1 .. 10);
my @arr_nums = (\@arr_num1, \@arr_num2, \@arr_num3);

#Cartesian
is_deeply [cartesian], [], 'cartesian returns no sets with no sets';
is_deeply [cartesian \@arr_num1], [map {[$_]} @arr_num1], 'cartesian returns each element as its own set with one set';
is_deeply [cartesian \@arr_num1, []], [[]], 'cartesian with the empty set returns the empty set';
is_deeply
	[cartesian @arr_nums],
	get_cartesian_arr_nums,
	'cartesian returns all permutations of one element from each set';
is_deeply
	[cartesian map { $_ } @arr_nums],
	get_cartesian_arr_nums,
	'cartesian works with internal iterators';
is_deeply
	[cartesian get_arr_different_sizes],
	get_cartesian_arr_different_sizes,
	'cartesian returns all permutations of one element from each set with different sized sets';


#Data Functions

sub get_cartesian_arr_nums() {
	return [
		[1,6,2],
		[1,6,4],
		[1,6,6],
		[1,6,8],
		[1,6,10],
		[1,6,12],
		[1,6,14],
		[1,6,16],
		[1,6,18],
		[1,6,20],
		[1,7,2],
		[1,7,4],
		[1,7,6],
		[1,7,8],
		[1,7,10],
		[1,7,12],
		[1,7,14],
		[1,7,16],
		[1,7,18],
		[1,7,20],
		[1,8,2],
		[1,8,4],
		[1,8,6],
		[1,8,8],
		[1,8,10],
		[1,8,12],
		[1,8,14],
		[1,8,16],
		[1,8,18],
		[1,8,20],
		[1,9,2],
		[1,9,4],
		[1,9,6],
		[1,9,8],
		[1,9,10],
		[1,9,12],
		[1,9,14],
		[1,9,16],
		[1,9,18],
		[1,9,20],
		[1,10,2],
		[1,10,4],
		[1,10,6],
		[1,10,8],
		[1,10,10],
		[1,10,12],
		[1,10,14],
		[1,10,16],
		[1,10,18],
		[1,10,20],
		[1,11,2],
		[1,11,4],
		[1,11,6],
		[1,11,8],
		[1,11,10],
		[1,11,12],
		[1,11,14],
		[1,11,16],
		[1,11,18],
		[1,11,20],
		[1,12,2],
		[1,12,4],
		[1,12,6],
		[1,12,8],
		[1,12,10],
		[1,12,12],
		[1,12,14],
		[1,12,16],
		[1,12,18],
		[1,12,20],
		[1,13,2],
		[1,13,4],
		[1,13,6],
		[1,13,8],
		[1,13,10],
		[1,13,12],
		[1,13,14],
		[1,13,16],
		[1,13,18],
		[1,13,20],
		[1,14,2],
		[1,14,4],
		[1,14,6],
		[1,14,8],
		[1,14,10],
		[1,14,12],
		[1,14,14],
		[1,14,16],
		[1,14,18],
		[1,14,20],
		[1,15,2],
		[1,15,4],
		[1,15,6],
		[1,15,8],
		[1,15,10],
		[1,15,12],
		[1,15,14],
		[1,15,16],
		[1,15,18],
		[1,15,20],
		[2,6,2],
		[2,6,4],
		[2,6,6],
		[2,6,8],
		[2,6,10],
		[2,6,12],
		[2,6,14],
		[2,6,16],
		[2,6,18],
		[2,6,20],
		[2,7,2],
		[2,7,4],
		[2,7,6],
		[2,7,8],
		[2,7,10],
		[2,7,12],
		[2,7,14],
		[2,7,16],
		[2,7,18],
		[2,7,20],
		[2,8,2],
		[2,8,4],
		[2,8,6],
		[2,8,8],
		[2,8,10],
		[2,8,12],
		[2,8,14],
		[2,8,16],
		[2,8,18],
		[2,8,20],
		[2,9,2],
		[2,9,4],
		[2,9,6],
		[2,9,8],
		[2,9,10],
		[2,9,12],
		[2,9,14],
		[2,9,16],
		[2,9,18],
		[2,9,20],
		[2,10,2],
		[2,10,4],
		[2,10,6],
		[2,10,8],
		[2,10,10],
		[2,10,12],
		[2,10,14],
		[2,10,16],
		[2,10,18],
		[2,10,20],
		[2,11,2],
		[2,11,4],
		[2,11,6],
		[2,11,8],
		[2,11,10],
		[2,11,12],
		[2,11,14],
		[2,11,16],
		[2,11,18],
		[2,11,20],
		[2,12,2],
		[2,12,4],
		[2,12,6],
		[2,12,8],
		[2,12,10],
		[2,12,12],
		[2,12,14],
		[2,12,16],
		[2,12,18],
		[2,12,20],
		[2,13,2],
		[2,13,4],
		[2,13,6],
		[2,13,8],
		[2,13,10],
		[2,13,12],
		[2,13,14],
		[2,13,16],
		[2,13,18],
		[2,13,20],
		[2,14,2],
		[2,14,4],
		[2,14,6],
		[2,14,8],
		[2,14,10],
		[2,14,12],
		[2,14,14],
		[2,14,16],
		[2,14,18],
		[2,14,20],
		[2,15,2],
		[2,15,4],
		[2,15,6],
		[2,15,8],
		[2,15,10],
		[2,15,12],
		[2,15,14],
		[2,15,16],
		[2,15,18],
		[2,15,20],
		[3,6,2],
		[3,6,4],
		[3,6,6],
		[3,6,8],
		[3,6,10],
		[3,6,12],
		[3,6,14],
		[3,6,16],
		[3,6,18],
		[3,6,20],
		[3,7,2],
		[3,7,4],
		[3,7,6],
		[3,7,8],
		[3,7,10],
		[3,7,12],
		[3,7,14],
		[3,7,16],
		[3,7,18],
		[3,7,20],
		[3,8,2],
		[3,8,4],
		[3,8,6],
		[3,8,8],
		[3,8,10],
		[3,8,12],
		[3,8,14],
		[3,8,16],
		[3,8,18],
		[3,8,20],
		[3,9,2],
		[3,9,4],
		[3,9,6],
		[3,9,8],
		[3,9,10],
		[3,9,12],
		[3,9,14],
		[3,9,16],
		[3,9,18],
		[3,9,20],
		[3,10,2],
		[3,10,4],
		[3,10,6],
		[3,10,8],
		[3,10,10],
		[3,10,12],
		[3,10,14],
		[3,10,16],
		[3,10,18],
		[3,10,20],
		[3,11,2],
		[3,11,4],
		[3,11,6],
		[3,11,8],
		[3,11,10],
		[3,11,12],
		[3,11,14],
		[3,11,16],
		[3,11,18],
		[3,11,20],
		[3,12,2],
		[3,12,4],
		[3,12,6],
		[3,12,8],
		[3,12,10],
		[3,12,12],
		[3,12,14],
		[3,12,16],
		[3,12,18],
		[3,12,20],
		[3,13,2],
		[3,13,4],
		[3,13,6],
		[3,13,8],
		[3,13,10],
		[3,13,12],
		[3,13,14],
		[3,13,16],
		[3,13,18],
		[3,13,20],
		[3,14,2],
		[3,14,4],
		[3,14,6],
		[3,14,8],
		[3,14,10],
		[3,14,12],
		[3,14,14],
		[3,14,16],
		[3,14,18],
		[3,14,20],
		[3,15,2],
		[3,15,4],
		[3,15,6],
		[3,15,8],
		[3,15,10],
		[3,15,12],
		[3,15,14],
		[3,15,16],
		[3,15,18],
		[3,15,20],
		[4,6,2],
		[4,6,4],
		[4,6,6],
		[4,6,8],
		[4,6,10],
		[4,6,12],
		[4,6,14],
		[4,6,16],
		[4,6,18],
		[4,6,20],
		[4,7,2],
		[4,7,4],
		[4,7,6],
		[4,7,8],
		[4,7,10],
		[4,7,12],
		[4,7,14],
		[4,7,16],
		[4,7,18],
		[4,7,20],
		[4,8,2],
		[4,8,4],
		[4,8,6],
		[4,8,8],
		[4,8,10],
		[4,8,12],
		[4,8,14],
		[4,8,16],
		[4,8,18],
		[4,8,20],
		[4,9,2],
		[4,9,4],
		[4,9,6],
		[4,9,8],
		[4,9,10],
		[4,9,12],
		[4,9,14],
		[4,9,16],
		[4,9,18],
		[4,9,20],
		[4,10,2],
		[4,10,4],
		[4,10,6],
		[4,10,8],
		[4,10,10],
		[4,10,12],
		[4,10,14],
		[4,10,16],
		[4,10,18],
		[4,10,20],
		[4,11,2],
		[4,11,4],
		[4,11,6],
		[4,11,8],
		[4,11,10],
		[4,11,12],
		[4,11,14],
		[4,11,16],
		[4,11,18],
		[4,11,20],
		[4,12,2],
		[4,12,4],
		[4,12,6],
		[4,12,8],
		[4,12,10],
		[4,12,12],
		[4,12,14],
		[4,12,16],
		[4,12,18],
		[4,12,20],
		[4,13,2],
		[4,13,4],
		[4,13,6],
		[4,13,8],
		[4,13,10],
		[4,13,12],
		[4,13,14],
		[4,13,16],
		[4,13,18],
		[4,13,20],
		[4,14,2],
		[4,14,4],
		[4,14,6],
		[4,14,8],
		[4,14,10],
		[4,14,12],
		[4,14,14],
		[4,14,16],
		[4,14,18],
		[4,14,20],
		[4,15,2],
		[4,15,4],
		[4,15,6],
		[4,15,8],
		[4,15,10],
		[4,15,12],
		[4,15,14],
		[4,15,16],
		[4,15,18],
		[4,15,20],
		[5,6,2],
		[5,6,4],
		[5,6,6],
		[5,6,8],
		[5,6,10],
		[5,6,12],
		[5,6,14],
		[5,6,16],
		[5,6,18],
		[5,6,20],
		[5,7,2],
		[5,7,4],
		[5,7,6],
		[5,7,8],
		[5,7,10],
		[5,7,12],
		[5,7,14],
		[5,7,16],
		[5,7,18],
		[5,7,20],
		[5,8,2],
		[5,8,4],
		[5,8,6],
		[5,8,8],
		[5,8,10],
		[5,8,12],
		[5,8,14],
		[5,8,16],
		[5,8,18],
		[5,8,20],
		[5,9,2],
		[5,9,4],
		[5,9,6],
		[5,9,8],
		[5,9,10],
		[5,9,12],
		[5,9,14],
		[5,9,16],
		[5,9,18],
		[5,9,20],
		[5,10,2],
		[5,10,4],
		[5,10,6],
		[5,10,8],
		[5,10,10],
		[5,10,12],
		[5,10,14],
		[5,10,16],
		[5,10,18],
		[5,10,20],
		[5,11,2],
		[5,11,4],
		[5,11,6],
		[5,11,8],
		[5,11,10],
		[5,11,12],
		[5,11,14],
		[5,11,16],
		[5,11,18],
		[5,11,20],
		[5,12,2],
		[5,12,4],
		[5,12,6],
		[5,12,8],
		[5,12,10],
		[5,12,12],
		[5,12,14],
		[5,12,16],
		[5,12,18],
		[5,12,20],
		[5,13,2],
		[5,13,4],
		[5,13,6],
		[5,13,8],
		[5,13,10],
		[5,13,12],
		[5,13,14],
		[5,13,16],
		[5,13,18],
		[5,13,20],
		[5,14,2],
		[5,14,4],
		[5,14,6],
		[5,14,8],
		[5,14,10],
		[5,14,12],
		[5,14,14],
		[5,14,16],
		[5,14,18],
		[5,14,20],
		[5,15,2],
		[5,15,4],
		[5,15,6],
		[5,15,8],
		[5,15,10],
		[5,15,12],
		[5,15,14],
		[5,15,16],
		[5,15,18],
		[5,15,20],
		[6,6,2],
		[6,6,4],
		[6,6,6],
		[6,6,8],
		[6,6,10],
		[6,6,12],
		[6,6,14],
		[6,6,16],
		[6,6,18],
		[6,6,20],
		[6,7,2],
		[6,7,4],
		[6,7,6],
		[6,7,8],
		[6,7,10],
		[6,7,12],
		[6,7,14],
		[6,7,16],
		[6,7,18],
		[6,7,20],
		[6,8,2],
		[6,8,4],
		[6,8,6],
		[6,8,8],
		[6,8,10],
		[6,8,12],
		[6,8,14],
		[6,8,16],
		[6,8,18],
		[6,8,20],
		[6,9,2],
		[6,9,4],
		[6,9,6],
		[6,9,8],
		[6,9,10],
		[6,9,12],
		[6,9,14],
		[6,9,16],
		[6,9,18],
		[6,9,20],
		[6,10,2],
		[6,10,4],
		[6,10,6],
		[6,10,8],
		[6,10,10],
		[6,10,12],
		[6,10,14],
		[6,10,16],
		[6,10,18],
		[6,10,20],
		[6,11,2],
		[6,11,4],
		[6,11,6],
		[6,11,8],
		[6,11,10],
		[6,11,12],
		[6,11,14],
		[6,11,16],
		[6,11,18],
		[6,11,20],
		[6,12,2],
		[6,12,4],
		[6,12,6],
		[6,12,8],
		[6,12,10],
		[6,12,12],
		[6,12,14],
		[6,12,16],
		[6,12,18],
		[6,12,20],
		[6,13,2],
		[6,13,4],
		[6,13,6],
		[6,13,8],
		[6,13,10],
		[6,13,12],
		[6,13,14],
		[6,13,16],
		[6,13,18],
		[6,13,20],
		[6,14,2],
		[6,14,4],
		[6,14,6],
		[6,14,8],
		[6,14,10],
		[6,14,12],
		[6,14,14],
		[6,14,16],
		[6,14,18],
		[6,14,20],
		[6,15,2],
		[6,15,4],
		[6,15,6],
		[6,15,8],
		[6,15,10],
		[6,15,12],
		[6,15,14],
		[6,15,16],
		[6,15,18],
		[6,15,20],
		[7,6,2],
		[7,6,4],
		[7,6,6],
		[7,6,8],
		[7,6,10],
		[7,6,12],
		[7,6,14],
		[7,6,16],
		[7,6,18],
		[7,6,20],
		[7,7,2],
		[7,7,4],
		[7,7,6],
		[7,7,8],
		[7,7,10],
		[7,7,12],
		[7,7,14],
		[7,7,16],
		[7,7,18],
		[7,7,20],
		[7,8,2],
		[7,8,4],
		[7,8,6],
		[7,8,8],
		[7,8,10],
		[7,8,12],
		[7,8,14],
		[7,8,16],
		[7,8,18],
		[7,8,20],
		[7,9,2],
		[7,9,4],
		[7,9,6],
		[7,9,8],
		[7,9,10],
		[7,9,12],
		[7,9,14],
		[7,9,16],
		[7,9,18],
		[7,9,20],
		[7,10,2],
		[7,10,4],
		[7,10,6],
		[7,10,8],
		[7,10,10],
		[7,10,12],
		[7,10,14],
		[7,10,16],
		[7,10,18],
		[7,10,20],
		[7,11,2],
		[7,11,4],
		[7,11,6],
		[7,11,8],
		[7,11,10],
		[7,11,12],
		[7,11,14],
		[7,11,16],
		[7,11,18],
		[7,11,20],
		[7,12,2],
		[7,12,4],
		[7,12,6],
		[7,12,8],
		[7,12,10],
		[7,12,12],
		[7,12,14],
		[7,12,16],
		[7,12,18],
		[7,12,20],
		[7,13,2],
		[7,13,4],
		[7,13,6],
		[7,13,8],
		[7,13,10],
		[7,13,12],
		[7,13,14],
		[7,13,16],
		[7,13,18],
		[7,13,20],
		[7,14,2],
		[7,14,4],
		[7,14,6],
		[7,14,8],
		[7,14,10],
		[7,14,12],
		[7,14,14],
		[7,14,16],
		[7,14,18],
		[7,14,20],
		[7,15,2],
		[7,15,4],
		[7,15,6],
		[7,15,8],
		[7,15,10],
		[7,15,12],
		[7,15,14],
		[7,15,16],
		[7,15,18],
		[7,15,20],
		[8,6,2],
		[8,6,4],
		[8,6,6],
		[8,6,8],
		[8,6,10],
		[8,6,12],
		[8,6,14],
		[8,6,16],
		[8,6,18],
		[8,6,20],
		[8,7,2],
		[8,7,4],
		[8,7,6],
		[8,7,8],
		[8,7,10],
		[8,7,12],
		[8,7,14],
		[8,7,16],
		[8,7,18],
		[8,7,20],
		[8,8,2],
		[8,8,4],
		[8,8,6],
		[8,8,8],
		[8,8,10],
		[8,8,12],
		[8,8,14],
		[8,8,16],
		[8,8,18],
		[8,8,20],
		[8,9,2],
		[8,9,4],
		[8,9,6],
		[8,9,8],
		[8,9,10],
		[8,9,12],
		[8,9,14],
		[8,9,16],
		[8,9,18],
		[8,9,20],
		[8,10,2],
		[8,10,4],
		[8,10,6],
		[8,10,8],
		[8,10,10],
		[8,10,12],
		[8,10,14],
		[8,10,16],
		[8,10,18],
		[8,10,20],
		[8,11,2],
		[8,11,4],
		[8,11,6],
		[8,11,8],
		[8,11,10],
		[8,11,12],
		[8,11,14],
		[8,11,16],
		[8,11,18],
		[8,11,20],
		[8,12,2],
		[8,12,4],
		[8,12,6],
		[8,12,8],
		[8,12,10],
		[8,12,12],
		[8,12,14],
		[8,12,16],
		[8,12,18],
		[8,12,20],
		[8,13,2],
		[8,13,4],
		[8,13,6],
		[8,13,8],
		[8,13,10],
		[8,13,12],
		[8,13,14],
		[8,13,16],
		[8,13,18],
		[8,13,20],
		[8,14,2],
		[8,14,4],
		[8,14,6],
		[8,14,8],
		[8,14,10],
		[8,14,12],
		[8,14,14],
		[8,14,16],
		[8,14,18],
		[8,14,20],
		[8,15,2],
		[8,15,4],
		[8,15,6],
		[8,15,8],
		[8,15,10],
		[8,15,12],
		[8,15,14],
		[8,15,16],
		[8,15,18],
		[8,15,20],
		[9,6,2],
		[9,6,4],
		[9,6,6],
		[9,6,8],
		[9,6,10],
		[9,6,12],
		[9,6,14],
		[9,6,16],
		[9,6,18],
		[9,6,20],
		[9,7,2],
		[9,7,4],
		[9,7,6],
		[9,7,8],
		[9,7,10],
		[9,7,12],
		[9,7,14],
		[9,7,16],
		[9,7,18],
		[9,7,20],
		[9,8,2],
		[9,8,4],
		[9,8,6],
		[9,8,8],
		[9,8,10],
		[9,8,12],
		[9,8,14],
		[9,8,16],
		[9,8,18],
		[9,8,20],
		[9,9,2],
		[9,9,4],
		[9,9,6],
		[9,9,8],
		[9,9,10],
		[9,9,12],
		[9,9,14],
		[9,9,16],
		[9,9,18],
		[9,9,20],
		[9,10,2],
		[9,10,4],
		[9,10,6],
		[9,10,8],
		[9,10,10],
		[9,10,12],
		[9,10,14],
		[9,10,16],
		[9,10,18],
		[9,10,20],
		[9,11,2],
		[9,11,4],
		[9,11,6],
		[9,11,8],
		[9,11,10],
		[9,11,12],
		[9,11,14],
		[9,11,16],
		[9,11,18],
		[9,11,20],
		[9,12,2],
		[9,12,4],
		[9,12,6],
		[9,12,8],
		[9,12,10],
		[9,12,12],
		[9,12,14],
		[9,12,16],
		[9,12,18],
		[9,12,20],
		[9,13,2],
		[9,13,4],
		[9,13,6],
		[9,13,8],
		[9,13,10],
		[9,13,12],
		[9,13,14],
		[9,13,16],
		[9,13,18],
		[9,13,20],
		[9,14,2],
		[9,14,4],
		[9,14,6],
		[9,14,8],
		[9,14,10],
		[9,14,12],
		[9,14,14],
		[9,14,16],
		[9,14,18],
		[9,14,20],
		[9,15,2],
		[9,15,4],
		[9,15,6],
		[9,15,8],
		[9,15,10],
		[9,15,12],
		[9,15,14],
		[9,15,16],
		[9,15,18],
		[9,15,20],
		[10,6,2],
		[10,6,4],
		[10,6,6],
		[10,6,8],
		[10,6,10],
		[10,6,12],
		[10,6,14],
		[10,6,16],
		[10,6,18],
		[10,6,20],
		[10,7,2],
		[10,7,4],
		[10,7,6],
		[10,7,8],
		[10,7,10],
		[10,7,12],
		[10,7,14],
		[10,7,16],
		[10,7,18],
		[10,7,20],
		[10,8,2],
		[10,8,4],
		[10,8,6],
		[10,8,8],
		[10,8,10],
		[10,8,12],
		[10,8,14],
		[10,8,16],
		[10,8,18],
		[10,8,20],
		[10,9,2],
		[10,9,4],
		[10,9,6],
		[10,9,8],
		[10,9,10],
		[10,9,12],
		[10,9,14],
		[10,9,16],
		[10,9,18],
		[10,9,20],
		[10,10,2],
		[10,10,4],
		[10,10,6],
		[10,10,8],
		[10,10,10],
		[10,10,12],
		[10,10,14],
		[10,10,16],
		[10,10,18],
		[10,10,20],
		[10,11,2],
		[10,11,4],
		[10,11,6],
		[10,11,8],
		[10,11,10],
		[10,11,12],
		[10,11,14],
		[10,11,16],
		[10,11,18],
		[10,11,20],
		[10,12,2],
		[10,12,4],
		[10,12,6],
		[10,12,8],
		[10,12,10],
		[10,12,12],
		[10,12,14],
		[10,12,16],
		[10,12,18],
		[10,12,20],
		[10,13,2],
		[10,13,4],
		[10,13,6],
		[10,13,8],
		[10,13,10],
		[10,13,12],
		[10,13,14],
		[10,13,16],
		[10,13,18],
		[10,13,20],
		[10,14,2],
		[10,14,4],
		[10,14,6],
		[10,14,8],
		[10,14,10],
		[10,14,12],
		[10,14,14],
		[10,14,16],
		[10,14,18],
		[10,14,20],
		[10,15,2],
		[10,15,4],
		[10,15,6],
		[10,15,8],
		[10,15,10],
		[10,15,12],
		[10,15,14],
		[10,15,16],
		[10,15,18],
		[10,15,20],
	];
}

sub get_arr_different_sizes() {
	return (
		[1 .. 5],
		[6,7],
		[8],
		[9 .. 12],
		[13 .. 15]
	);
}
sub get_cartesian_arr_different_sizes() {
	return [
		[1,6,8, 9,13],
		[1,6,8, 9,14],
		[1,6,8, 9,15],
		[1,6,8,10,13],
		[1,6,8,10,14],
		[1,6,8,10,15],
		[1,6,8,11,13],
		[1,6,8,11,14],
		[1,6,8,11,15],
		[1,6,8,12,13],
		[1,6,8,12,14],
		[1,6,8,12,15],
		[1,7,8, 9,13],
		[1,7,8, 9,14],
		[1,7,8, 9,15],
		[1,7,8,10,13],
		[1,7,8,10,14],
		[1,7,8,10,15],
		[1,7,8,11,13],
		[1,7,8,11,14],
		[1,7,8,11,15],
		[1,7,8,12,13],
		[1,7,8,12,14],
		[1,7,8,12,15],
		[2,6,8, 9,13],
		[2,6,8, 9,14],
		[2,6,8, 9,15],
		[2,6,8,10,13],
		[2,6,8,10,14],
		[2,6,8,10,15],
		[2,6,8,11,13],
		[2,6,8,11,14],
		[2,6,8,11,15],
		[2,6,8,12,13],
		[2,6,8,12,14],
		[2,6,8,12,15],
		[2,7,8, 9,13],
		[2,7,8, 9,14],
		[2,7,8, 9,15],
		[2,7,8,10,13],
		[2,7,8,10,14],
		[2,7,8,10,15],
		[2,7,8,11,13],
		[2,7,8,11,14],
		[2,7,8,11,15],
		[2,7,8,12,13],
		[2,7,8,12,14],
		[2,7,8,12,15],
		[3,6,8, 9,13],
		[3,6,8, 9,14],
		[3,6,8, 9,15],
		[3,6,8,10,13],
		[3,6,8,10,14],
		[3,6,8,10,15],
		[3,6,8,11,13],
		[3,6,8,11,14],
		[3,6,8,11,15],
		[3,6,8,12,13],
		[3,6,8,12,14],
		[3,6,8,12,15],
		[3,7,8, 9,13],
		[3,7,8, 9,14],
		[3,7,8, 9,15],
		[3,7,8,10,13],
		[3,7,8,10,14],
		[3,7,8,10,15],
		[3,7,8,11,13],
		[3,7,8,11,14],
		[3,7,8,11,15],
		[3,7,8,12,13],
		[3,7,8,12,14],
		[3,7,8,12,15],
		[4,6,8, 9,13],
		[4,6,8, 9,14],
		[4,6,8, 9,15],
		[4,6,8,10,13],
		[4,6,8,10,14],
		[4,6,8,10,15],
		[4,6,8,11,13],
		[4,6,8,11,14],
		[4,6,8,11,15],
		[4,6,8,12,13],
		[4,6,8,12,14],
		[4,6,8,12,15],
		[4,7,8, 9,13],
		[4,7,8, 9,14],
		[4,7,8, 9,15],
		[4,7,8,10,13],
		[4,7,8,10,14],
		[4,7,8,10,15],
		[4,7,8,11,13],
		[4,7,8,11,14],
		[4,7,8,11,15],
		[4,7,8,12,13],
		[4,7,8,12,14],
		[4,7,8,12,15],
		[5,6,8, 9,13],
		[5,6,8, 9,14],
		[5,6,8, 9,15],
		[5,6,8,10,13],
		[5,6,8,10,14],
		[5,6,8,10,15],
		[5,6,8,11,13],
		[5,6,8,11,14],
		[5,6,8,11,15],
		[5,6,8,12,13],
		[5,6,8,12,14],
		[5,6,8,12,15],
		[5,7,8, 9,13],
		[5,7,8, 9,14],
		[5,7,8, 9,15],
		[5,7,8,10,13],
		[5,7,8,10,14],
		[5,7,8,10,15],
		[5,7,8,11,13],
		[5,7,8,11,14],
		[5,7,8,11,15],
		[5,7,8,12,13],
		[5,7,8,12,14],
		[5,7,8,12,15],
	];
}
