use 5.010;
use strict;
use warnings FATAL => 'all';
use ExtUtils::MakeMaker;

WriteMakefile(
    NAME             => 'Dependencies::Searcher',
    AUTHOR           => q{smonf <smonff@riseup.net>},
    VERSION_FROM     => 'lib/Dependencies/Searcher.pm',
    ABSTRACT_FROM    => 'lib/Dependencies/Searcher.pm',
    LICENSE          => 'Perl_5',
    PL_FILES         => {},
    CONFIGURE_REQUIRES => {
	'ExtUtils::MakeMaker' => 6.74,
    },
    BUILD_REQUIRES => {
	'Test::More' => 0,
	'IO::File'   => 0,
    },
    TEST_REQUIRES => {
	'Module::Version'     => 0.12,
	'Test::Pod::Coverage' => 1.08,
	'Test::Pod'           => 1.48,
    },
    # For any module added, please add it to t/09-cpanfile.t too or
    # tests will fail :D
    PREREQ_PM => {
	'Data::Printer'         => 0.35,
	'File::HomeDir'         => 1.00,
        'File::Next'            => 1.12,
        'Module::CoreList'      => 5.20160429,
	'Module::Version'       => 0.12,
	'Moose'                 => 2.0602,
	'Path::Class'           => 0.32,
        'PPI'                   => 1.220,
	'Version::Compare'      => 0.14,
    },

    MIN_PERL_VERSION => '5.010',
    dist  => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
    clean => { FILES => 'Dependencies-Searcher-*' },

    META_MERGE        => {
        "meta-spec" => { version => 2 },
        resources => {
            repository => {
                type => 'git',
                url => 'git://git.framasoft.org:smonff/dependencies-searcher.git',
                web => 'https://git.framasoft.org/smonff/dependencies-searcher',
            },
        },
    },
 );
