#!/usr/bin/env perl
use strict;
use warnings;

use Test::More tests => 3;
use Test::MockModule;
use Test::Exception;

use Git::Wrapper::More;

# hides, but it's tested:
# [error][string] git exited non-zero but had no output to stderr
close(STDERR);
my $hide_stderr;
open( STDERR, ">>", \$hide_stderr );

{
    my $label = 'Happy Path';

    my $mgwm = Test::MockModule->new('Git::Wrapper');
    $mgwm->mock(
        'config',
        sub {
            my $self = shift;
            return 'origin';
        },
    );

    my $gwm = Git::Wrapper::More->new( dir => '/dummy/dir' );

    my $ret = $gwm->getremote('dummy_branch');
    like( $ret, qr/^origin$/,
        "$label: getremote returns the remote string from Git::Wrapper config" );
}

{
    my $label = 'Empty Remote';

    # Git::Wrapper dies when there's no tracked remote
    my $mgwm = Test::MockModule->new('Git::Wrapper');
    $mgwm->mock(
        'config',
        sub {
            my $self = shift;
            die 'git exited non-zero but had no output to stderr';
        },
    );

    my $gwm = Git::Wrapper::More->new( dir => '/dummy/dir' );

    lives_ok { $gwm->getremote('dummy_branch') } "$label: getremote lives";
    like(
        $hide_stderr,
        qr/git exited non-zero but had no output to stderr/,
        "$label: error printed to stderr"
    );
}

exit;

__END__
