/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ContextSwitchingExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.QuantifiedExpression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.instruct.ApplyTemplates;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.instruct.Template;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.sort.DocumentSorter;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.RuleTarget;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;

public class Optimizer
implements Serializable {
    public static final int NO_OPTIMIZATION = 0;
    public static final int FULL_OPTIMIZATION = 10;
    protected Configuration config;
    private int optimizationLevel = 10;

    public Optimizer(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setOptimizationLevel(int level) {
        if (level < 0 || level > 10) {
            throw new IllegalArgumentException("Optimization level");
        }
        this.optimizationLevel = level;
    }

    public int getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public BinaryExpression optimizeGeneralComparison(GeneralComparison gc, boolean backwardsCompatible) {
        return gc;
    }

    public Expression optimizeCopy(Expression select) throws XPathException {
        TypeHierarchy th = this.config.getTypeHierarchy();
        if (select.getItemType(th).isPlainType()) {
            return select;
        }
        return null;
    }

    public Expression convertPathExpressionToKey(SlashExpression pathExp, ExpressionVisitor visitor) throws XPathException {
        return null;
    }

    public Expression tryIndexedFilter(FilterExpression f, ExpressionVisitor visitor, boolean indexFirstOperand) {
        return f;
    }

    public FilterExpression convertToFilterExpression(SlashExpression pathExp, TypeHierarchy th) throws XPathException {
        return null;
    }

    public int isIndexableFilter(Expression filter) {
        return 0;
    }

    public ValueRepresentation makeIndexedValue(SequenceIterator iter) throws XPathException {
        throw new UnsupportedOperationException("Indexing requires Saxon-EE");
    }

    public boolean isVariableReplaceableByDot(Expression exp, Binding[] binding) {
        if (exp instanceof ContextSwitchingExpression) {
            Expression start = ((ContextSwitchingExpression)((Object)exp)).getControllingExpression();
            Expression step = ((ContextSwitchingExpression)((Object)exp)).getControlledExpression();
            return this.isVariableReplaceableByDot(start, binding) && !ExpressionTool.dependsOnVariable(step, binding);
        }
        Iterator<Expression> iter = exp.iterateSubExpressions();
        while (iter.hasNext()) {
            Expression sub = iter.next();
            if (this.isVariableReplaceableByDot(sub, binding)) continue;
            return false;
        }
        return true;
    }

    public Expression makeConditionalDocumentSorter(DocumentSorter sorter, SlashExpression path) {
        return sorter;
    }

    public Expression tryInlineFunctionCall(UserFunctionCall functionCall, ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) {
        return functionCall;
    }

    public Expression promoteExpressionsToGlobal(Expression body, ExpressionVisitor visitor) throws XPathException {
        return null;
    }

    public Expression trySwitch(Choose choose, StaticContext env) {
        return choose;
    }

    public Expression extractGlobalVariables(Expression body, ExpressionVisitor visitor, PromotionOffer offer) throws XPathException {
        return null;
    }

    public Expression makeStreamingApplyTemplates(ApplyTemplates inst) throws XPathException {
        return inst;
    }

    public RuleTarget makeInversion(Pattern pattern, Template template, NodeTest nodeTest) throws XPathException {
        return null;
    }

    public void makeCopyOperationsExplicit(Expression parent, Expression child) throws XPathException {
    }

    public Expression makeCastToUnion(Expression operand, SchemaType targetType, boolean allowsEmpty) {
        throw new UnsupportedOperationException("Cast to union is not supported in Saxon-HE");
    }

    public Expression makeCastToList(Expression operand, SchemaType targetType, boolean allowsEmpty) {
        throw new UnsupportedOperationException("Cast to List is not supported in Saxon-HE");
    }

    public Expression makeCastableToUnion(Expression operand, SchemaType targetType, boolean allowsEmpty) {
        throw new UnsupportedOperationException("Cast to List is not supported in Saxon-HE");
    }

    public Expression makeCastableToList(Expression operand, SchemaType targetType, boolean allowsEmpty) {
        throw new UnsupportedOperationException("Cast to List is not supported in Saxon-HE");
    }

    public Expression optimizeForExpressionForStreaming(ForExpression expr) throws XPathException {
        return expr;
    }

    public Expression makeOuterForExpression() {
        throw new UnsupportedOperationException("'allowing empty' is supported only in Saxon-EE");
    }

    public Expression optimizeQuantifiedExpressionForStreaming(QuantifiedExpression expr) throws XPathException {
        return expr;
    }

    public Expression generateMultithreadedInstruction(Expression instruction) {
        return instruction;
    }

    public Expression compileToByteCode(Expression expr, String objectName, int evaluationMethods) {
        return null;
    }

    public void trace(String message, Expression exp) {
        if (this.getConfiguration().isOptimizerTracing()) {
            PrintStream err = this.getConfiguration().getStandardErrorOutput();
            err.println("OPT ======================================");
            err.println("OPT : At line " + exp.getLineNumber() + " of " + exp.getSystemId());
            err.println("OPT : " + message);
            err.println("OPT ====== Expression after rewrite ======");
            exp.explain(err);
            err.println("\nOPT ======================================");
        }
    }

    public void trace(String message) {
        if (this.getConfiguration().isOptimizerTracing()) {
            PrintStream err = this.getConfiguration().getStandardErrorOutput();
            err.println("OPT ======================================");
            err.println("OPT : " + message);
            err.println("OPT ======================================");
        }
    }
}

