/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.io.Serializable;
import net.sf.saxon.lib.StringCollator;

public class CaseFirstCollator
implements StringCollator,
Serializable {
    private StringCollator baseCollator;
    private boolean upperFirst;

    public CaseFirstCollator(StringCollator base, boolean upperFirst) {
        this.baseCollator = base;
        this.upperFirst = upperFirst;
    }

    public int compareStrings(String a, String b) {
        int diff = this.baseCollator.compareStrings(a, b);
        if (diff != 0) {
            return diff;
        }
        int i = 0;
        int j = 0;
        while (true) {
            boolean bFirst;
            if (i < a.length() && j < b.length() && a.charAt(i) == b.charAt(j)) {
                ++i;
                ++j;
                continue;
            }
            while (i < a.length() && !Character.isLetter(a.charAt(i))) {
                ++i;
            }
            while (j < b.length() && !Character.isLetter(b.charAt(j))) {
                ++j;
            }
            if (i >= a.length()) {
                return 0;
            }
            if (j >= b.length()) {
                return 0;
            }
            boolean aFirst = this.upperFirst ? Character.isUpperCase(a.charAt(i++)) : Character.isLowerCase(a.charAt(i++));
            boolean bl = bFirst = this.upperFirst ? Character.isUpperCase(b.charAt(j++)) : Character.isLowerCase(b.charAt(j++));
            if (aFirst && !bFirst) {
                return -1;
            }
            if (bFirst && !aFirst) break;
        }
        return 1;
    }

    public boolean comparesEqual(String s1, String s2) {
        return this.compareStrings(s1, s2) == 0;
    }

    public Object getCollationKey(String s) {
        return this.baseCollator.getCollationKey(s);
    }
}

