<?xml version="1.0" encoding="UTF-8"?>
<tree_query xmlns="http://ufal.mff.cuni.cz/pdt/pml/">
  <head>
    <schema href="tree_query_schema.xml"/>
  </head>
  <q-trees>
    <LM id="t-nodes">
      <q-nodes>
        <node>
          <name>n</name>
          <node-type>t-node</node-type>
        </node>
      </q-nodes>
      <output-filters>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>$n.id</LM>
          </return>
          <sort-by>
            <LM>$1</LM>
          </sort-by>
        </LM>
      </output-filters>
    </LM>
    <LM id="a-nodes">
      <q-nodes>
        <node>
          <name>n</name>
          <node-type>a-node</node-type>
        </node>
      </q-nodes>
      <output-filters>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>$n.id</LM>
          </return>
          <sort-by>
            <LM>$1</LM>
          </sort-by>
        </LM>
      </output-filters>
    </LM>
    <LM id="t-x-dependency">
      <description>Prohozená závislost</description>
      <q-nodes>
        <node>
          <name>n0</name>
          <node-type>t-node</node-type>
          <q-children>
            <ref>
              <relation>
                <user-defined label="a/lex.rf">
                </user-defined>
              </relation>
              <target>ref1</target>
            </ref>
            <node>
              <name>n1</name>
              <node-type>t-node</node-type>
              <q-children>
                <ref>
                  <relation>
                    <user-defined label="a/lex.rf">
                    </user-defined>
                  </relation>
                  <target>ref0</target>
                </ref>
              </q-children>
            </node>
          </q-children>
        </node>
        <node>
          <name>ref0</name>
          <node-type>a-node</node-type>
          <q-children>
            <node>
              <name>ref1</name>
              <node-type>a-node</node-type>
            </node>
          </q-children>
        </node>
      </q-nodes>
      <output-filters>
        <LM>
          <distinct>1</distinct>
          <return>
            <LM>$n0.id</LM>
            <LM>$n1.id</LM>
            <LM>$ref0.id</LM>
            <LM>$ref1.id</LM>
          </return>
          <sort-by>
            <LM>$1</LM>
            <LM>$2</LM>
            <LM>$3</LM>
            <LM>$4</LM>
          </sort-by>
        </LM>
      </output-filters>
    </LM>
    <LM id="t-q-09-02-24_152152">
      <description>quote-set mnozina pokryvajici nejvetsi pocet a-uzlu</description>
      <q-nodes>
        <node>
          <name>n</name>
          <node-type>t-node</node-type>
          <q-children>
            <node>
              <name>a</name>
              <node-type>a-node</node-type>
              <relation>
                <user-defined label="a/lex.rf|a/aux.rf">
                </user-defined>
              </relation>
            </node>
            <test operator="!=">
              <a>quot/set_id</a>
              <b>''</b>
            </test>
            <or>
              <not>
                <test operator="=">
                  <a>is_generated</a>
                  <b>1</b>
                </test>
              </not>
              <and>
                <ref>
                  <relation>
                    <user-defined label="a/aux.rf">
                    </user-defined>
                  </relation>
                  <target>a</target>
                </ref>
                <test operator="=">
                  <a>is_generated</a>
                  <b>1</b>
                </test>
              </and>
            </or>
          </q-children>
        </node>
      </q-nodes>
      <output-filters>
        <LM>
          <distinct>1</distinct>
          <return>
            <LM>$n.quot/set_id</LM>
            <LM>$a.id</LM>
          </return>
        </LM>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>$1</LM>
            <LM>count($2)</LM>
          </return>
          <group-by>
            <LM>$1</LM>
          </group-by>
          <sort-by>
            <LM>$2 desc</LM>
            <LM>$1</LM>
          </sort-by>
        </LM>
      </output-filters>
    </LM>
    <LM id="a-q-09-02-16_165819">
      <q-nodes>
        <node>
          <name>a</name>
          <node-type>a-node</node-type>
          <q-children>
            <test operator="=">
              <a>afun</a>
              <b>'Sb'</b>
            </test>
            <not>
              <test operator="~">
                <a>m/tag</a>
                <b>'^N...1'</b>
              </test>
            </not>
          </q-children>
        </node>
      </q-nodes>
      <output-filters>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>$a.id</LM>
          </return>
          <sort-by>
            <LM>$1</LM>
          </sort-by>
        </LM>
      </output-filters>
    </LM>
    <LM id="t-rcp">
      <description>chyby v Rcp</description>
      <node-type>t-node</node-type>
      <q-nodes>
        <node>
          <name>n0</name>
          <node-type>t-node</node-type>
          <q-children>
            <test operator="=">
              <a>t_lemma</a>
              <b>'#Rcp'</b>
            </test>
            <not>
              <subquery>
                <name>n1</name>
                <node-type>t-node</node-type>
                <relation>
                  <user-defined label="coref_gram.rf">
                  </user-defined>
                </relation>
                <occurrences>
                  <min>1</min>
                  <max>1</max>
                </occurrences>
              </subquery>
            </not>
          </q-children>
        </node>
      </q-nodes>
      <output-filters>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>$n0.id</LM>
          </return>
          <sort-by>
            <LM>$1</LM>
          </sort-by>
        </LM>
      </output-filters>
    </LM>
    <LM id="t-non-projective">
      <description>Neprojektivní hrana</description>
      <q-nodes>
        <node>
          <name>ref1</name>
          <node-type>t-node</node-type>
          <q-children>
            <node>
              <name>ref0</name>
              <node-type>t-node</node-type>
              <relation>
                <parent label="parent">
                </parent>
              </relation>
              <q-children>
                <subquery>
                  <name>ref2</name>
                  <node-type>t-node</node-type>
                  <relation>
                    <same-tree-as label="same-tree-as">
                    </same-tree-as>
                  </relation>
                  <q-children>
                    <not>
                      <ref>
                        <relation>
                          <ancestor label="ancestor">
                          </ancestor>
                        </relation>
                        <target>ref0</target>
                      </ref>
                    </not>
                    <or>
                      <and>
                        <ref>
                          <relation>
                            <order-follows label="order-follows">
                            </order-follows>
                          </relation>
                          <target>ref0</target>
                        </ref>
                        <ref>
                          <relation>
                            <order-precedes label="order-precedes">
                            </order-precedes>
                          </relation>
                          <target>ref1</target>
                        </ref>
                      </and>
                      <and>
                        <ref>
                          <relation>
                            <order-follows label="order-follows">
                            </order-follows>
                          </relation>
                          <target>ref1</target>
                        </ref>
                        <ref>
                          <relation>
                            <order-precedes label="order-precedes">
                            </order-precedes>
                          </relation>
                          <target>ref0</target>
                        </ref>
                      </and>
                    </or>
                  </q-children>
                  <occurrences>
                    <min>1</min>
                  </occurrences>
                </subquery>
              </q-children>
            </node>
          </q-children>
        </node>
      </q-nodes>
      <output-filters>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>$ref1.id</LM>
            <LM>$ref0.id</LM>
          </return>
          <sort-by>
            <LM>$1</LM>
            <LM>$2</LM>
          </sort-by>
        </LM>
      </output-filters>
    </LM>
    <LM id="a-non-projective">
      <description>Neprojektivní hrana (a-rovina)</description>
      <q-nodes>
        <node>
          <name>n2</name>
          <node-type>a-node</node-type>
          <relation>
            <descendant label="descendant">
            </descendant>
          </relation>
          <q-children>
            <not>
              <ref>
                <relation>
                  <ancestor label="ancestor">
                  </ancestor>
                </relation>
                <target>ref0</target>
              </ref>
            </not>
            <or>
              <and>
                <ref>
                  <relation>
                    <order-precedes label="order-precedes">
                    </order-precedes>
                  </relation>
                  <target>ref0</target>
                </ref>
                <ref>
                  <relation>
                    <order-follows label="order-follows">
                    </order-follows>
                  </relation>
                  <target>ref1</target>
                </ref>
              </and>
              <and>
                <ref>
                  <relation>
                    <order-follows label="order-follows">
                    </order-follows>
                  </relation>
                  <target>ref0</target>
                </ref>
                <ref>
                  <relation>
                    <order-precedes label="order-precedes">
                    </order-precedes>
                  </relation>
                  <target>ref1</target>
                </ref>
              </and>
            </or>
          </q-children>
        </node>
        <node>
          <name>ref0</name>
          <node-type>a-node</node-type>
          <relation>
            <descendant label="descendant">
            </descendant>
          </relation>
          <q-children>
            <ref>
              <relation>
                <same-tree-as>
                </same-tree-as>
              </relation>
              <target>n2</target>
            </ref>
            <node>
              <name>ref1</name>
              <node-type>a-node</node-type>
            </node>
          </q-children>
        </node>
      </q-nodes>
      <output-filters>
        <LM>
          <distinct>1</distinct>
          <return>
            <LM>$ref1</LM>
          </return>
        </LM>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>count()</LM>
          </return>
        </LM>
      </output-filters>
    </LM>
    <LM id="t-gram-coref-to-other-sent">
      <description>Gramatická koreference do jiné věty</description>
      <node-type>t-node</node-type>
      <q-nodes>
        <node>
          <name>ref2</name>
          <node-type>t-node</node-type>
          <q-children>
            <ref>
              <relation>
                <user-defined label="coref_gram.rf">
                </user-defined>
              </relation>
              <target>ref1</target>
            </ref>
          </q-children>
        </node>
        <node>
          <name>ref1</name>
          <node-type>t-node</node-type>
          <q-children>
            <not>
              <ref>
                <relation>
                  <same-tree-as label="same-tree-as">
                  </same-tree-as>
                </relation>
                <target>ref2</target>
              </ref>
            </not>
          </q-children>
        </node>
      </q-nodes>
      <output-filters>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>$ref1.id</LM>
            <LM>$ref2.id</LM>
          </return>
          <sort-by>
            <LM>$1</LM>
            <LM>$2</LM>
          </sort-by>
        </LM>
      </output-filters>
    </LM>
    <LM id="a-is-member">
      <description>is_member musí mít rodiče Coord nebo Apos (skrz Aux[CP])</description>
      <node-type>a-node</node-type>
      <q-nodes>
        <node>
          <name>n0</name>
          <node-type>a-node</node-type>
          <q-children>
            <test operator="=">
              <a>is_member</a>
              <b>1</b>
            </test>
            <node>
              <name>coord</name>
              <node-type>a-node</node-type>
              <relation>
                <ancestor label="ancestor">
                </ancestor>
              </relation>
              <q-children>
                <not>
                  <test operator="~">
                    <a>afun</a>
                    <b>'Coord|Apos|Aux[CP]'</b>
                  </test>
                </not>
              </q-children>
            </node>
            <subquery>
              <name>n1</name>
              <node-type>a-node</node-type>
              <relation>
                <ancestor label="ancestor">
                </ancestor>
              </relation>
              <q-children>
                <not>
                  <test operator="~">
                    <a>afun</a>
                    <b>'Aux[CP]'</b>
                  </test>
                </not>
                <ref>
                  <relation>
                    <ancestor label="ancestor">
                    </ancestor>
                  </relation>
                  <target>coord</target>
                </ref>
              </q-children>
              <occurrences>
                <min>0</min>
                <max>0</max>
              </occurrences>
            </subquery>
          </q-children>
        </node>
      </q-nodes>
      <output-filters>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>$n0.id</LM>
            <LM>$coord.id</LM>
          </return>
          <sort-by>
            <LM>$1</LM>
            <LM>$2</LM>
          </sort-by>
        </LM>
      </output-filters>
    </LM>
    <LM id="t-count-t-nodes">
      <description>Počet tektogramatických uzlů</description>
      <q-nodes>
        <node>
          <node-type>t-node</node-type>
        </node>
      </q-nodes>
      <output-filters>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>count()</LM>
          </return>
        </LM>
      </output-filters>
    </LM>
    <LM id="a-count-a-nodes">
      <description>počet analytických uzlů</description>
      <q-nodes>
        <node>
          <node-type>a-node</node-type>
        </node>
      </q-nodes>
      <output-filters>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>count()</LM>
          </return>
        </LM>
      </output-filters>
    </LM>
    <LM id="t-max-depth">
      <description>Hloubka nejhlubšího stromu</description>
      <q-nodes>
        <node>
          <node-type>t-node</node-type>
        </node>
      </q-nodes>
      <output-filters>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>max(depth())</LM>
          </return>
        </LM>
      </output-filters>
    </LM>
    <LM id="t-tree-sizes-2">
      <description>Velikost t-stromů</description>
      <q-nodes>
        <node>
          <name>r</name>
          <node-type>t-root</node-type>
          <q-children>
            <node>
              <node-type>t-node</node-type>
              <relation>
                <descendant label="descendant">
                </descendant>
              </relation>
            </node>
          </q-children>
        </node>
      </q-nodes>
      <output-filters>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>count()</LM>
          </return>
          <group-by>
            <LM>$r</LM>
          </group-by>
        </LM>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>min()</LM>
            <LM>max()</LM>
            <LM>round(avg(),4)</LM>
            <LM>sum()</LM>
          </return>
        </LM>
      </output-filters>
    </LM>
    <LM id="a-tree-sizes-3">
      <q-nodes>
        <node>
          <node-type>a-root</node-type>
        </node>
      </q-nodes>
      <output-filters>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>descendants()</LM>
          </return>
        </LM>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>min()</LM>
            <LM>max()</LM>
            <LM>round(avg(),4)</LM>
            <LM>sum()</LM>
          </return>
        </LM>
      </output-filters>
    </LM>
    <LM id="t-tree-sizes">
      <description>Četnost stromů podle počtu uzlů</description>
      <q-nodes>
        <node>
          <name>r</name>
          <node-type>t-root</node-type>
          <q-children>
            <node>
              <name>n</name>
              <node-type>t-node</node-type>
              <relation>
                <descendant label="descendant">
                </descendant>
              </relation>
            </node>
          </q-children>
        </node>
      </q-nodes>
      <output-filters>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>count($n)</LM>
          </return>
          <group-by>
            <LM>$r</LM>
          </group-by>
        </LM>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>$1</LM>
            <LM>count()</LM>
          </return>
          <group-by>
            <LM>$1</LM>
          </group-by>
          <sort-by>
            <LM>$2 desc</LM>
            <LM>$1</LM>
          </sort-by>
        </LM>
      </output-filters>
    </LM>
    <LM id="t-dative-func">
      <description>Functors for dative</description>
      <q-nodes>
        <node>
          <name>t</name>
          <node-type>t-node</node-type>
          <q-children>
            <node>
              <node-type>a-node</node-type>
              <relation>
                <user-defined label="a/lex.rf">
                </user-defined>
              </relation>
              <q-children>
                <test operator="~">
                  <a>m/tag</a>
                  <b>'^....3'</b>
                </test>
              </q-children>
            </node>
          </q-children>
        </node>
      </q-nodes>
      <output-filters>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>$1</LM>
            <LM>count()</LM>
          </return>
          <group-by>
            <LM>$t.functor</LM>
          </group-by>
          <sort-by>
            <LM>$2</LM>
            <LM>$1</LM>
          </sort-by>
        </LM>
      </output-filters>
    </LM>
    <LM id="t-LOC-DIR-preps">
      <description>Předložky vyjadřující LOC a DIR</description>
      <q-nodes>
        <node>
          <node-type>t-node</node-type>
          <q-children>
            <test operator="~">
              <a>functor</a>
              <b>'^LOC|^DIR[1-3]'</b>
            </test>
            <node>
              <name>a</name>
              <node-type>a-node</node-type>
              <relation>
                <user-defined label="a/aux.rf">
                </user-defined>
              </relation>
              <q-children>
                <test operator="=">
                  <a>afun</a>
                  <b>'AuxP'</b>
                </test>
              </q-children>
            </node>
          </q-children>
        </node>
      </q-nodes>
      <output-filters>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>match($a.m/lemma,'^[^_`]*')</LM>
          </return>
        </LM>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>$1</LM>
            <LM>count()</LM>
          </return>
          <group-by>
            <LM>$1</LM>
          </group-by>
          <sort-by>
            <LM>$2 desc</LM>
            <LM>$1</LM>
          </sort-by>
        </LM>
      </output-filters>
    </LM>
    <LM id="t-verb-lemmas-cphr">
      <description>Slovesa s CPHR</description>
      <q-nodes>
        <node>
          <name>n</name>
          <node-type>t-node</node-type>
          <q-children>
            <node>
              <node-type>t-node</node-type>
              <relation>
                <user-defined label="echild">
                </user-defined>
              </relation>
              <q-children>
                <test operator="=">
                  <a>functor</a>
                  <b>'CPHR'</b>
                </test>
              </q-children>
            </node>
          </q-children>
        </node>
      </q-nodes>
      <output-filters>
        <LM>
          <distinct>1</distinct>
          <return>
            <LM>$n.t_lemma</LM>
          </return>
          <sort-by>
            <LM>$1</LM>
          </sort-by>
        </LM>
      </output-filters>
    </LM>
    <LM id="t-joint-functor-distribution">
      <description>Které dvojice funktorů nejčastěji stojí na efektivní hraně</description>
      <node-type>t-node</node-type>
      <q-nodes>
        <node>
          <name>p</name>
          <node-type>t-node</node-type>
          <q-children>
            <node>
              <name>c</name>
              <node-type>t-node</node-type>
              <relation>
                <user-defined label="echild">
                </user-defined>
              </relation>
            </node>
          </q-children>
        </node>
      </q-nodes>
      <output-filters>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>$1</LM>
            <LM>$2</LM>
            <LM>ratio(count() over $1)</LM>
          </return>
          <group-by>
            <LM>$p.functor</LM>
            <LM>$c.functor</LM>
          </group-by>
          <sort-by>
            <LM>$1</LM>
            <LM>$3 desc</LM>
            <LM>$2</LM>
          </sort-by>
        </LM>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>$1</LM>
            <LM>$2</LM>
            <LM>percnt($3,2)</LM>
          </return>
        </LM>
      </output-filters>
    </LM>
    <LM id="t-eff-indirect">
      <description>Efektivní nepřímí potomci</description>
      <node-type>t-node</node-type>
      <q-nodes>
        <node>
          <name>n0</name>
          <node-type>t-node</node-type>
          <q-children>
            <test operator="=">
              <a>functor</a>
              <b>'PRED'</b>
            </test>
            <not>
              <ref>
                <relation>
                  <child label="child">
                  </child>
                </relation>
                <target>act</target>
              </ref>
            </not>
            <not>
              <ref>
                <relation>
                  <child label="child">
                  </child>
                </relation>
                <target>pat</target>
              </ref>
            </not>
            <node>
              <name>act</name>
              <node-type>t-node</node-type>
              <relation>
                <user-defined label="echild">
                </user-defined>
              </relation>
              <q-children>
                <test operator="=">
                  <a>functor</a>
                  <b>'ACT'</b>
                </test>
              </q-children>
            </node>
            <node>
              <name>pat</name>
              <node-type>t-node</node-type>
              <relation>
                <user-defined label="echild">
                </user-defined>
              </relation>
              <q-children>
                <test operator="=">
                  <a>functor</a>
                  <b>'PAT'</b>
                </test>
              </q-children>
            </node>
          </q-children>
        </node>
      </q-nodes>
      <output-filters>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>$n0.id</LM>
            <LM>$act.id</LM>
            <LM>$pat.id</LM>
          </return>
          <sort-by>
            <LM>$1</LM>
            <LM>$2</LM>
            <LM>$3</LM>
          </sort-by>
        </LM>
      </output-filters>
    </LM>
    <LM id="t-CM">
      <q-nodes>
        <node>
          <name>n0</name>
          <node-type>t-node</node-type>
          <q-children>
            <subquery>
              <name>n1</name>
              <node-type>t-node</node-type>
              <relation>
                <ancestor label="ancestor">
                </ancestor>
              </relation>
              <q-children>
                <subquery>
                  <name>n2</name>
                  <node-type>t-node</node-type>
                  <q-children>
                    <not>
                      <test operator="=">
                        <a>is_member</a>
                        <b>1</b>
                      </test>
                    </not>
                    <not>
                      <test operator="=">
                        <a>functor</a>
                        <b>'CM'</b>
                      </test>
                    </not>
                  </q-children>
                  <occurrences>
                    <min>3</min>
                  </occurrences>
                </subquery>
                <test operator="=">
                  <a>nodetype</a>
                  <b>'coap'</b>
                </test>
              </q-children>
              <occurrences>
                <min>2</min>
                <max>2</max>
              </occurrences>
            </subquery>
          </q-children>
        </node>
      </q-nodes>
      <output-filters>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>$n0.id</LM>
          </return>
          <sort-by>
            <LM>$1</LM>
          </sort-by>
        </LM>
      </output-filters>
    </LM>
    <LM id="a-exd-common-dep">
      <description>''ExD'' jako společné rozvití</description>
      <node-type>a-node</node-type>
      <q-nodes>
        <node>
          <name>exd</name>
          <node-type>a-node</node-type>
          <q-children>
            <node>
              <name>n0</name>
              <node-type>a-node</node-type>
              <relation>
                <user-defined label="eparent">
                </user-defined>
              </relation>
              <q-children>
                <not>
                  <ref>
                    <relation>
                      <descendant label="descendant">
                      </descendant>
                    </relation>
                    <target>exd</target>
                  </ref>
                </not>
                <not>
                  <test operator="~">
                    <a>afun</a>
                    <b>'^Aux|^ExD'</b>
                  </test>
                </not>
              </q-children>
            </node>
            <test operator="=">
              <a>afun</a>
              <b>'ExD'</b>
            </test>
            <not>
              <test operator="=">
                <a>is_member</a>
                <b>1</b>
              </test>
            </not>
          </q-children>
        </node>
      </q-nodes>
      <output-filters>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>$exd.id</LM>
            <LM>$n0.id</LM>
          </return>
          <sort-by>
            <LM>$1</LM>
            <LM>$2</LM>
          </sort-by>
        </LM>
      </output-filters>
    </LM>
    <LM id="t-arbitrary1">
      <node-type>t-node</node-type>
      <q-nodes>
        <node>
          <name>n0</name>
          <node-type>t-node</node-type>
          <q-children>
            <node>
              <name>n1</name>
              <node-type>t-node</node-type>
              <relation>
                <user-defined label="echild">
                </user-defined>
              </relation>
              <q-children>
                <node>
                  <name>n2</name>
                  <node-type>t-node</node-type>
                  <q-children>
                    <node>
                      <name>n3</name>
                      <node-type>t-node</node-type>
                      <q-children>
                        <ref>
                          <relation>
                            <user-defined label="coref_text.rf">
                            </user-defined>
                          </relation>
                          <target>act</target>
                        </ref>
                      </q-children>
                    </node>
                  </q-children>
                </node>
                <subquery>
                  <name>n4</name>
                  <node-type>t-node</node-type>
                  <occurrences>
                    <min>3</min>
                    <max>3</max>
                  </occurrences>
                </subquery>
                <test operator="=">
                  <a>functor</a>
                  <b>'PAT'</b>
                </test>
              </q-children>
            </node>
            <node>
              <name>act</name>
              <node-type>t-node</node-type>
              <relation>
                <user-defined label="echild">
                </user-defined>
              </relation>
              <q-children>
                <test operator="=">
                  <a>functor</a>
                  <b>'ACT'</b>
                </test>
              </q-children>
            </node>
            <subquery>
              <name>n5</name>
              <node-type>t-node</node-type>
              <relation>
                <user-defined label="echild">
                </user-defined>
              </relation>
              <q-children>
                <node>
                  <name>n6</name>
                  <node-type>a-node</node-type>
                  <relation>
                    <user-defined label="a/lex.rf">
                    </user-defined>
                  </relation>
                  <q-children>
                    <test operator="~">
                      <a>m/tag</a>
                      <b>'^N'</b>
                    </test>
                  </q-children>
                </node>
                <test operator="=">
                  <a>functor</a>
                  <b>'ADDR'</b>
                </test>
              </q-children>
              <occurrences>
                <min>3</min>
                <max>3</max>
              </occurrences>
            </subquery>
            <test operator="=">
              <a>functor</a>
              <b>'PRED'</b>
            </test>
          </q-children>
        </node>
      </q-nodes>
      <output-filters>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>$n0.id</LM>
            <LM>$n1.id</LM>
            <LM>$n2.id</LM>
            <LM>$n3.id</LM>
            <LM>$act.id</LM>
          </return>
          <sort-by>
            <LM>$1</LM>
            <LM>$2</LM>
            <LM>$3</LM>
            <LM>$4</LM>
            <LM>$5</LM>
          </sort-by>
        </LM>
      </output-filters>
    </LM>
    <LM id="t-rici-1">
      <q-nodes>
        <node>
          <name>n0</name>
          <node-type>t-node</node-type>
          <q-children>
            <ref>
              <relation>
                <same-tree-as label="same-tree-as">
                </same-tree-as>
              </relation>
              <target>ref1</target>
            </ref>
            <ref>
              <relation>
                <user-defined label="a/lex.rf">
                </user-defined>
              </relation>
              <target>ref0</target>
            </ref>
          </q-children>
        </node>
        <node>
          <name>ref1</name>
          <node-type>t-node</node-type>
          <q-children>
            <ref>
              <relation>
                <user-defined label="a/lex.rf">
                </user-defined>
              </relation>
              <target>u</target>
            </ref>
          </q-children>
        </node>
        <node>
          <name>u</name>
          <node-type>a-node</node-type>
          <q-children>
            <test operator="~">
              <a>m/lemma</a>
              <b>'^upřímně'</b>
            </test>
          </q-children>
        </node>
        <node>
          <name>ref0</name>
          <node-type>a-node</node-type>
          <q-children>
            <test operator="~">
              <a>m/lemma</a>
              <b>'^říci'</b>
            </test>
            <test operator="=">
              <a>ord</a>
              <b>$u.ord+1</b>
            </test>
          </q-children>
        </node>
      </q-nodes>
      <output-filters>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>$n0.id</LM>
            <LM>$ref1.id</LM>
            <LM>$u.id</LM>
            <LM>$ref0.id</LM>
          </return>
          <sort-by>
            <LM>$1</LM>
            <LM>$2</LM>
            <LM>$3</LM>
            <LM>$4</LM>
          </sort-by>
        </LM>
      </output-filters>
    </LM>
    <LM id="t-q-08-10-09_120250">
      <q-nodes>
        <node>
          <name>n0</name>
          <node-type>t-node</node-type>
          <q-children>
            <test operator="=">
              <a>functor</a>
              <b>'DPHR'</b>
            </test>
          </q-children>
        </node>
      </q-nodes>
      <output-filters>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>$n0.id</LM>
          </return>
          <sort-by>
            <LM>$1</LM>
          </sort-by>
        </LM>
      </output-filters>
    </LM>
    <LM id="t-q-08-11-28_100504">
      <description>Discrepancies between a-layer and t-layer</description>
      <q-nodes>
        <node>
          <name>n6</name>
          <node-type>a-root</node-type>
          <q-children>
            <node>
              <name>n4</name>
              <node-type>a-node</node-type>
              <relation>
                <same-tree-as label="same-tree-as">
                </same-tree-as>
              </relation>
              <q-children>
                <node>
                  <name>n3</name>
                  <node-type>a-node</node-type>
                  <relation>
                    <user-defined label="echild">
                    </user-defined>
                  </relation>
                  <q-children>
                    <not>
                      <test operator="=">
                        <a>afun</a>
                        <b>'Apos'</b>
                      </test>
                    </not>
                    <not>
                      <test operator="=">
                        <a>afun</a>
                        <b>'Coord'</b>
                      </test>
                    </not>
                    <not>
                      <test operator="~">
                        <a>m/tag</a>
                        <b>'^C'</b>
                      </test>
                    </not>
                    <not>
                      <test operator="=">
                        <a>afun</a>
                        <b>'AuxZ'</b>
                      </test>
                    </not>
                  </q-children>
                </node>
                <not>
                  <test operator="~">
                    <a>m/tag</a>
                    <b>'^C'</b>
                  </test>
                </not>
                <not>
                  <test operator="=">
                    <a>afun</a>
                    <b>'Coord'</b>
                  </test>
                </not>
                <not>
                  <test operator="=">
                    <a>afun</a>
                    <b>'Apos'</b>
                  </test>
                </not>
              </q-children>
            </node>
          </q-children>
        </node>
        <node>
          <name>n0</name>
          <node-type>t-root</node-type>
          <q-children>
            <ref>
              <relation>
                <user-defined label="atree.rf">
                </user-defined>
              </relation>
              <target>n6</target>
            </ref>
            <node>
              <name>n5</name>
              <node-type>t-node</node-type>
              <relation>
                <same-tree-as label="same-tree-as">
                </same-tree-as>
              </relation>
              <q-children>
                <ref>
                  <relation>
                    <user-defined label="a/lex.rf">
                    </user-defined>
                  </relation>
                  <target>n4</target>
                </ref>
                <not>
                  <test operator="=">
                    <a>functor</a>
                    <b>'FPHR'</b>
                  </test>
                </not>
              </q-children>
            </node>
            <node>
              <name>n7</name>
              <node-type>t-node</node-type>
              <relation>
                <same-tree-as label="same-tree-as">
                </same-tree-as>
              </relation>
              <q-children>
                <not>
                  <test operator="=">
                    <a>functor</a>
                    <b>'FPHR'</b>
                  </test>
                </not>
                <ref>
                  <relation>
                    <user-defined label="a/lex.rf">
                    </user-defined>
                  </relation>
                  <target>n3</target>
                </ref>
              </q-children>
            </node>
            <subquery>
              <name>n1</name>
              <node-type>t-node</node-type>
              <relation>
                <same-tree-as label="same-tree-as">
                </same-tree-as>
              </relation>
              <q-children>
                <ref>
                  <relation>
                    <user-defined label="a/lex.rf">
                    </user-defined>
                  </relation>
                  <target>n4</target>
                </ref>
                <node>
                  <name>n2</name>
                  <node-type>t-node</node-type>
                  <relation>
                    <same-tree-as label="same-tree-as">
                    </same-tree-as>
                  </relation>
                  <q-children>
                    <ref>
                      <relation>
                        <user-defined label="a/lex.rf">
                        </user-defined>
                      </relation>
                      <target>n3</target>
                    </ref>
                    <not>
                      <test operator="=">
                        <a>functor</a>
                        <b>"FPHR"</b>
                      </test>
                    </not>
                    <or>
                      <ref>
                        <relation>
                          <user-defined label="eparent">
                          </user-defined>
                        </relation>
                        <target>n1</target>
                      </ref>
                      <ref>
                        <relation>
                          <user-defined label="echild">
                          </user-defined>
                        </relation>
                        <target>n1</target>
                      </ref>
                    </or>
                  </q-children>
                </node>
                <not>
                  <test operator="=">
                    <a>functor</a>
                    <b>"FPHR"</b>
                  </test>
                </not>
              </q-children>
              <occurrences>
                <min>0</min>
                <max>0</max>
              </occurrences>
            </subquery>
          </q-children>
        </node>
      </q-nodes>
      <output-filters>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>$n0.id</LM>
            <LM>$n7.id</LM>
            <LM>$n5.id</LM>
            <LM>$n6.id</LM>
            <LM>$n4.id</LM>
            <LM>$n3.id</LM>
          </return>
          <sort-by>
            <LM>$1</LM>
            <LM>$2</LM>
            <LM>$3</LM>
            <LM>$4</LM>
            <LM>$5</LM>
            <LM>$6</LM>
          </sort-by>
        </LM>
      </output-filters>
    </LM>
    <LM id="t-q-08-12-01_163623">
      <q-nodes>
        <node>
          <name>n</name>
          <node-type>t-node</node-type>
          <q-children>
            <not>
              <test operator=">">
                <a>length(gram/resultative)</a>
                <b>0</b>
              </test>
            </not>
          </q-children>
        </node>
      </q-nodes>
      <output-filters>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>$1</LM>
            <LM>count()</LM>
          </return>
          <group-by>
            <LM>$n.gram/resultative</LM>
          </group-by>
          <sort-by>
            <LM>$2 desc</LM>
            <LM>$1</LM>
          </sort-by>
        </LM>
      </output-filters>
    </LM>
    <LM id="a-q-08-12-08_151842">
      <q-nodes>
        <node>
          <name>n</name>
          <node-type>a-node</node-type>
          <q-children>
            <test operator="~">
              <a>m/w/token</a>
              <b>'f'</b>
            </test>
          </q-children>
        </node>
      </q-nodes>
      <output-filters>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>$n.id</LM>
          </return>
          <sort-by>
            <LM>$1</LM>
          </sort-by>
        </LM>
      </output-filters>
    </LM>
    <LM id="a-q-09-02-23_135541">
      <q-nodes>
        <node>
          <name>n</name>
          <node-type>a-node</node-type>
          <q-children>
            <not>
              <test operator="=">
                <a>m/w/token</a>
                <b>*m/w/token</b>
              </test>
            </not>
          </q-children>
        </node>
      </q-nodes>
      <output-filters>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>$n.id</LM>
          </return>
          <sort-by>
            <LM>$1</LM>
          </sort-by>
        </LM>
      </output-filters>
    </LM>
    <LM id="a-q-09-03-09_162605">
      <q-nodes>
        <node>
          <name>v</name>
          <node-type>a-node</node-type>
          <q-children>
            <node>
              <name>c</name>
              <node-type>a-node</node-type>
              <relation>
                <user-defined label="echild">
                </user-defined>
              </relation>
              <q-children>
                <test operator="in">
                  <a>afun</a>
                  <b>{ "Sb", "Obj" }</b>
                </test>
              </q-children>
            </node>
            <test operator="~">
              <a>m/tag</a>
              <b>'^V'</b>
            </test>
          </q-children>
        </node>
      </q-nodes>
      <output-filters>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>$v.id</LM>
            <LM>$c.ord - $v.ord</LM>
            <LM>substr($c.afun,0,1)</LM>
          </return>
        </LM>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>concat(substr($2,0,1) &amp; $3 over $1 sort by $2)</LM>
          </return>
        </LM>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>substitute(substitute(substitute(substitute($1, '-','','g'),'[0-9]|$','V'),'[0-9]','','g'),'(.)\\1+','\\1','g')</LM>
          </return>
        </LM>
        <LM>
          <distinct>0</distinct>
          <return>
            <LM>$1</LM>
            <LM>count()</LM>
          </return>
          <group-by>
            <LM>$1</LM>
          </group-by>
          <sort-by>
            <LM>$2</LM>
            <LM>$1</LM>
          </sort-by>
        </LM>
      </output-filters>
    </LM>
  </q-trees>
</tree_query>
