package App::Manoc::Form::Types::VlanID;

use Moose::Util::TypeConstraints;

our $VERSION = '2.99.4'; ##TRIAL VERSION

subtype 'VlanID' => as 'Int' => where { $_ >= 1 && $_ <= 4094 } =>
    message { "VLAN ID must be in 1-4094" };

no Moose::Util::TypeConstraints;

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::Form::Types::VlanID

=head1 VERSION

version 2.99.4

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
