package Net::Kubernetes::Role::ResourceFactory;
$Net::Kubernetes::Role::ResourceFactory::VERSION = '1.06';
# ABSTRACT: Role to allow easy construction of Net::Kubernetes::Resouce::* objects

use Moose::Role;
use MooseX::Aliases;
require Net::Kubernetes::Resource::Endpoint;
require Net::Kubernetes::Resource::Event;
require Net::Kubernetes::Resource::Node;
require Net::Kubernetes::Resource::Pod;
require Net::Kubernetes::Resource::ReplicationController;
require Net::Kubernetes::Resource::Secret;
require Net::Kubernetes::Resource::Service;
require Net::Kubernetes::Resource::ServiceAccount;
require Net::Kubernetes::Resource::Deployment;
require Net::Kubernetes::Resource::ReplicaSet;
require Net::Kubernetes::Resource::Role;
require Net::Kubernetes::Resource::RoleBinding;

with 'Net::Kubernetes::Role::ResourceCatalog';

sub create_resource_object {
    my ($self, $object, $kind) = @_;
    $kind ||= $object->{kind};
    $object->{kind} ||= $kind;
    my (%create_args) = %$object;
    $create_args{api_version}    = $object->{apiVersion};
    $create_args{server_version} = $self->server_version;

    unless ($self->is_global_resource($kind)) {
        $create_args{namespace} = $object->{namespace} || $self->namespace;
    }

    $create_args{username} = $self->username if ($self->username);
    $create_args{password} = $self->password if ($self->password);
    $create_args{token}    = $self->token    if ($self->token);
    $create_args{url}      = $self->url;
    $create_args{base_path}     = $object->{metadata}{selfLink};
    $create_args{ssl_cert_file} = $self->ssl_cert_file if ($self->ssl_cert_file);
    $create_args{ssl_key_file}  = $self->ssl_key_file if ($self->ssl_key_file);
    $create_args{ssl_ca_file}   = $self->ssl_ca_file if ($self->ssl_ca_file);
    $create_args{ssl_verify}    = $self->ssl_verify;
    my $class = "Net::Kubernetes::Resource::" . $kind;
    return $class->new(%create_args);
}

return 42;

__END__

=pod

=encoding UTF-8

=head1 NAME

Net::Kubernetes::Role::ResourceFactory - Role to allow easy construction of Net::Kubernetes::Resouce::* objects

=head1 VERSION

version 1.06

=head1 AUTHOR

Dave Mueller <dave@perljedi.com>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by Liquid Web Inc.

This is free software, licensed under:

  The MIT (X11) License

=head1 SEE ALSO

Please see those modules/websites for more information related to this module.

=over 4

=item *

L<Net::Kubernetes|Net::Kubernetes>

=back

=head1 CONSUMES

=over 4

=item * L<Net::Kubernetes::Role::ResourceCatalog>

=back

=cut
