package PROP::Conf::MySQL;

use strict;
use base qw/PROP::Conf/;
use IO::File;

sub _read_configuration {
    my ($self, $cnxn_conf) = @_;

    my $should_close = 0;

    unless(ref($cnxn_conf)) {
	unless($cnxn_conf = new IO::File($cnxn_conf)) {
	    my $msg = "could not open $cnxn_conf";
	    die new PROP::Exception($msg);
	}

	$should_close = 1;
    }

    $self->_parse_file($cnxn_conf);

    if($should_close) {
	unless($cnxn_conf->close()) {
	    my $msg = "could not close file: $!";
	    die new PROP::Exception($msg);
	}
    }
}

sub _parse_file {
    my ($self, $file) = @_;

    my $current_section = '';

    while(<$file>) {
	chomp;

	if(/^\s*\[(.+)\]\s*$/) {
	    $current_section = $1;
	}
	elsif(/^\s*(\S+)\s*=\s*(\S+)\s*$/) {
	    $self->_set_param($1, $2) if $current_section eq 'client';
	}
    }
}

sub get_dbd_name {
    return 'mysql';
}

1;

=head1 Name

PROP::Conf::MySQL

=head1 Description

This class is a subclass for PROP::Conf, and designed to parse
configuration information for the MySQL RDBMS.  Presently, it allows
the $cnxn_conf variable passed into _read_configuration to be a path
to a .my.cnf file that specifies all of the connection parameters.

=head1 Author

Andrew Gibbs (awgibbs@awgibbs.com,andrew.gibbs@nist.gov)

=head1 Legalese

This software was developed at the National Institute of Standards and
Technology by employees of the Federal Government in the course of
their official duties. Pursuant to title 17 Section 105 of the United
States Code this software is not subject to copyright protection and
is in the public domain. PROP is an experimental system. NIST
assumes no responsibility whatsoever for its use by other parties, and
makes no guarantees, expressed or implied, about its quality,
reliability, or any other characteristic. We would appreciate
acknowledgement if the software is used.  This software can be
redistributed and/or modified freely provided that any derivative
works bear some notice that they are derived from it, and any modified
versions bear some notice that they have been modified.
